/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.configuration.backend;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.configuration.ConcurrentWriteConfiguration;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.configuration.ReadConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.KeySliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.util.BackendOperation;
import org.janusgraph.diskstorage.util.BufferUtil;
import org.janusgraph.diskstorage.util.StaticArrayBuffer;
import org.janusgraph.diskstorage.util.StaticArrayEntry;
import org.janusgraph.diskstorage.util.time.TimestampProvider;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.serialize.DataOutput;
import org.janusgraph.graphdb.database.serialize.StandardSerializer;
import org.janusgraph.util.system.IOUtils;

public class KCVSConfiguration
implements ConcurrentWriteConfiguration {
    private final BackendOperation.TransactionalProvider txProvider;
    private final TimestampProvider times;
    private final KeyColumnValueStore store;
    private final StaticBuffer rowKey;
    private final StandardSerializer serializer;
    private Duration maxOperationWaitTime = Duration.ofMillis(10000L);

    public KCVSConfiguration(BackendOperation.TransactionalProvider txProvider, Configuration config, KeyColumnValueStore store, String identifier) throws BackendException {
        Preconditions.checkArgument((txProvider != null && store != null && config != null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)identifier));
        this.txProvider = txProvider;
        this.times = config.get(GraphDatabaseConfiguration.TIMESTAMP_PROVIDER, new String[0]);
        this.store = store;
        this.rowKey = this.string2StaticBuffer(identifier);
        this.serializer = new StandardSerializer();
    }

    public void setMaxOperationWaitTime(Duration waitTime) {
        Preconditions.checkArgument((Duration.ZERO.compareTo(waitTime) < 0 ? 1 : 0) != 0, (String)"Wait time must be nonnegative: %s", (Object[])new Object[]{waitTime});
        this.maxOperationWaitTime = waitTime;
    }

    @Override
    public <O> O get(String key, Class<O> dataType) {
        StaticBuffer column = this.string2StaticBuffer(key);
        final KeySliceQuery query = new KeySliceQuery(this.rowKey, column, BufferUtil.nextBiggerBuffer(column));
        StaticBuffer result = BackendOperation.execute(new BackendOperation.Transactional<StaticBuffer>(){

            @Override
            public StaticBuffer call(StoreTransaction txh) throws BackendException {
                EntryList entries = KCVSConfiguration.this.store.getSlice(query, txh);
                if (entries.isEmpty()) {
                    return null;
                }
                return ((Entry)entries.get(0)).getValueAs(StaticBuffer.STATIC_FACTORY);
            }

            public String toString() {
                return "getConfiguration";
            }
        }, this.txProvider, this.times, this.maxOperationWaitTime);
        if (result == null) {
            return null;
        }
        return this.staticBuffer2Object(result, dataType);
    }

    @Override
    public <O> void set(String key, O value, O expectedValue) {
        this.set(key, value, expectedValue, true);
    }

    @Override
    public <O> void set(String key, O value) {
        this.set(key, value, null, false);
    }

    public <O> void set(String key, O value, O expectedValue, final boolean checkExpectedValue) {
        ArrayList deletions;
        List<Entry> additions;
        final StaticBuffer column = this.string2StaticBuffer(key);
        if (value != null) {
            additions = new ArrayList<Entry>(1);
            deletions = KeyColumnValueStore.NO_DELETIONS;
            StaticBuffer val = this.object2StaticBuffer(value);
            additions.add(StaticArrayEntry.of(column, val));
        } else {
            additions = KeyColumnValueStore.NO_ADDITIONS;
            deletions = Lists.newArrayList((Object[])new StaticBuffer[]{column});
        }
        final StaticBuffer expectedValueBuffer = checkExpectedValue && expectedValue != null ? this.object2StaticBuffer(expectedValue) : null;
        BackendOperation.execute(new BackendOperation.Transactional<Boolean>(){

            @Override
            public Boolean call(StoreTransaction txh) throws BackendException {
                if (checkExpectedValue) {
                    KCVSConfiguration.this.store.acquireLock(KCVSConfiguration.this.rowKey, column, expectedValueBuffer, txh);
                }
                KCVSConfiguration.this.store.mutate(KCVSConfiguration.this.rowKey, additions, deletions, txh);
                return true;
            }

            public String toString() {
                return "setConfiguration";
            }
        }, this.txProvider, this.times, this.maxOperationWaitTime);
    }

    @Override
    public void remove(String key) {
        this.set(key, null);
    }

    @Override
    public WriteConfiguration copy() {
        throw new UnsupportedOperationException();
    }

    private Map<String, Object> toMap() {
        HashMap entries = Maps.newHashMap();
        List<Entry> result = BackendOperation.execute(new BackendOperation.Transactional<List<Entry>>(){

            @Override
            public List<Entry> call(StoreTransaction txh) throws BackendException {
                return KCVSConfiguration.this.store.getSlice(new KeySliceQuery(KCVSConfiguration.this.rowKey, BufferUtil.zeroBuffer(1), BufferUtil.oneBuffer(128)), txh);
            }

            public String toString() {
                return "setConfiguration";
            }
        }, this.txProvider, this.times, this.maxOperationWaitTime);
        for (Entry entry : result) {
            String key = this.staticBuffer2String(entry.getColumnAs(StaticBuffer.STATIC_FACTORY));
            Object value = this.staticBuffer2Object(entry.getValueAs(StaticBuffer.STATIC_FACTORY), Object.class);
            entries.put(key, value);
        }
        return entries;
    }

    public ReadConfiguration asReadConfiguration() {
        final Map<String, Object> entries = this.toMap();
        return new ReadConfiguration(){

            @Override
            public <O> O get(String key, Class<O> dataType) {
                Preconditions.checkArgument((!entries.containsKey(key) || dataType.isAssignableFrom(entries.get(key).getClass()) ? 1 : 0) != 0);
                return (O)entries.get(key);
            }

            @Override
            public Iterable<String> getKeys(String prefix) {
                boolean prefixBlank = StringUtils.isBlank((String)prefix);
                return entries.keySet().stream().filter(s -> prefixBlank || s.startsWith(prefix)).collect(Collectors.toList());
            }

            @Override
            public void close() {
            }
        };
    }

    @Override
    public Iterable<String> getKeys(String prefix) {
        return this.asReadConfiguration().getKeys(prefix);
    }

    @Override
    public void close() {
        try {
            this.store.close();
            this.txProvider.close();
            IOUtils.closeQuietly(this.serializer);
        }
        catch (BackendException e) {
            throw new JanusGraphException("Could not close configuration store", e);
        }
    }

    private StaticBuffer string2StaticBuffer(String s) {
        ByteBuffer out = ByteBuffer.wrap(s.getBytes(Charset.forName("UTF-8")));
        return StaticArrayBuffer.of(out);
    }

    private String staticBuffer2String(StaticBuffer s) {
        return new String(s.as(StaticBuffer.ARRAY_FACTORY), Charset.forName("UTF-8"));
    }

    private <O> StaticBuffer object2StaticBuffer(O value) {
        if (value == null) {
            throw Graph.Variables.Exceptions.variableValueCanNotBeNull();
        }
        if (!this.serializer.validDataType(value.getClass())) {
            throw Graph.Variables.Exceptions.dataTypeOfVariableValueNotSupported(value);
        }
        DataOutput out = this.serializer.getDataOutput(128);
        out.writeClassAndObject(value);
        return out.getStaticBuffer();
    }

    private <O> O staticBuffer2Object(StaticBuffer s, Class<O> dataType) {
        Object value = this.serializer.readClassAndObject(s.asReadBuffer());
        Preconditions.checkArgument((boolean)dataType.isInstance(value), (String)"Could not deserialize to [%s], got: %s", (Object[])new Object[]{dataType, value});
        return (O)value;
    }
}

