/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.schema;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.janusgraph.core.schema.SchemaStatus;

public enum SchemaAction {
    REGISTER_INDEX,
    REINDEX,
    ENABLE_INDEX,
    DISABLE_INDEX,
    REMOVE_INDEX;


    public Set<SchemaStatus> getApplicableStatus() {
        switch (this) {
            case REGISTER_INDEX: {
                return ImmutableSet.of((Object)((Object)SchemaStatus.INSTALLED));
            }
            case REINDEX: {
                return ImmutableSet.of((Object)((Object)SchemaStatus.REGISTERED), (Object)((Object)SchemaStatus.ENABLED));
            }
            case ENABLE_INDEX: {
                return ImmutableSet.of((Object)((Object)SchemaStatus.REGISTERED));
            }
            case DISABLE_INDEX: {
                return ImmutableSet.of((Object)((Object)SchemaStatus.REGISTERED), (Object)((Object)SchemaStatus.INSTALLED), (Object)((Object)SchemaStatus.ENABLED));
            }
            case REMOVE_INDEX: {
                return ImmutableSet.of((Object)((Object)SchemaStatus.DISABLED));
            }
        }
        throw new IllegalArgumentException("Action is invalid: " + (Object)((Object)this));
    }

    public Set<SchemaStatus> getFailureStatus() {
        switch (this) {
            case REGISTER_INDEX: {
                return ImmutableSet.of((Object)((Object)SchemaStatus.DISABLED));
            }
            case REINDEX: {
                return ImmutableSet.of((Object)((Object)SchemaStatus.INSTALLED), (Object)((Object)SchemaStatus.DISABLED));
            }
            case ENABLE_INDEX: {
                return ImmutableSet.of((Object)((Object)SchemaStatus.INSTALLED), (Object)((Object)SchemaStatus.DISABLED));
            }
            case DISABLE_INDEX: {
                return ImmutableSet.of();
            }
            case REMOVE_INDEX: {
                return ImmutableSet.of((Object)((Object)SchemaStatus.REGISTERED), (Object)((Object)SchemaStatus.INSTALLED), (Object)((Object)SchemaStatus.ENABLED));
            }
        }
        throw new IllegalArgumentException("Action is invalid: " + (Object)((Object)this));
    }

    public boolean isApplicableStatus(SchemaStatus status) {
        if (this.getFailureStatus().contains((Object)status)) {
            throw new IllegalArgumentException(String.format("Update action [%s] cannot be invoked for index with status [%s]", new Object[]{this, status}));
        }
        return this.getApplicableStatus().contains((Object)status);
    }
}

