/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.attribute;

import com.google.common.base.Preconditions;
import java.util.Collection;
import org.janusgraph.graphdb.query.JanusGraphPredicate;

public enum Contain implements JanusGraphPredicate
{
    IN{

        @Override
        public boolean test(Object value, Object condition) {
            Preconditions.checkArgument((boolean)this.isValidCondition(condition), (String)"Invalid condition provided: %s", (Object[])new Object[]{condition});
            Collection col = (Collection)condition;
            return col.contains(value);
        }

        @Override
        public JanusGraphPredicate negate() {
            return NOT_IN;
        }
    }
    ,
    NOT_IN{

        @Override
        public boolean test(Object value, Object condition) {
            Preconditions.checkArgument((boolean)this.isValidCondition(condition), (String)"Invalid condition provided: %s", (Object[])new Object[]{condition});
            Collection col = (Collection)condition;
            return !col.contains(value);
        }

        @Override
        public JanusGraphPredicate negate() {
            return IN;
        }
    };


    @Override
    public boolean isValidValueType(Class<?> clazz) {
        return true;
    }

    @Override
    public boolean isValidCondition(Object condition) {
        return condition != null && condition instanceof Collection;
    }

    @Override
    public boolean hasNegation() {
        return true;
    }

    @Override
    public boolean isQNF() {
        return false;
    }
}

