/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.simulator.simulators.nrm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.random.RandomGenerator;
import org.jamesii.core.util.eventset.Entry;
import org.jamesii.core.util.eventset.IEventQueue;
import org.jamesii.core.util.misc.Pair;
import org.jamesii.ml3.model.Model;
import org.jamesii.ml3.model.Parameters;
import org.jamesii.ml3.model.agents.AgentDeclaration;
import org.jamesii.ml3.model.agents.AgentField;
import org.jamesii.ml3.model.agents.IAgent;
import org.jamesii.ml3.model.agents.IAgentFactory;
import org.jamesii.ml3.model.agents.rules.Rule;
import org.jamesii.ml3.model.agents.rules.RuleInstanciation;
import org.jamesii.ml3.model.state.IState;
import org.jamesii.ml3.model.values.AgentValue;
import org.jamesii.ml3.model.values.BoolValue;
import org.jamesii.ml3.model.values.IValue;
import org.jamesii.ml3.model.values.SetValue;
import org.jamesii.ml3.simulator.context.IContext;
import org.jamesii.ml3.simulator.context.SimpleContext;
import org.jamesii.ml3.simulator.evaluate.BasicExpressionEvaluator;
import org.jamesii.ml3.simulator.evaluate.BasicStatementEvaluator;
import org.jamesii.ml3.simulator.evaluate.ExpressionEvaluationProtocol;
import org.jamesii.ml3.simulator.evaluate.IExpressionEvaluator;
import org.jamesii.ml3.simulator.evaluate.IStatementEvaluator;
import org.jamesii.ml3.simulator.evaluate.StatementEvaluationProtocol;
import org.jamesii.ml3.simulator.rates.BasicActivationTimeDrawer;
import org.jamesii.ml3.simulator.rates.ConstantPieceVisitor;
import org.jamesii.ml3.simulator.rates.RateEvaluationProtocol;
import org.jamesii.ml3.simulator.simulators.AbstractSimulator;
import org.jamesii.ml3.simulator.simulators.nrm.DependencyManagingAgent;
import org.jamesii.ml3.simulator.simulators.nrm.DependencyManagingInstance;
import org.jamesii.ml3.simulator.simulators.nrm.ForEachInstanceSet;
import org.jamesii.ml3.simulator.simulators.nrm.TypeDependencyMap;
import org.jamesii.ml3.simulator.stop.IStopCondition;

public class NextReactionSimulator
extends AbstractSimulator {
    private IEventQueue<DependencyManagingInstance, Double> queue;
    private Set<DependencyManagingInstance> unqueued;
    private double time;
    private Model model;
    private IState state;
    private IContext context;
    private IExpressionEvaluator exev;
    private IStatementEvaluator stev;
    private BasicActivationTimeDrawer atd;
    private TypeDependencyMap tdm;

    public NextReactionSimulator(Model model, IAgentFactory agentFactory, RandomGenerator rng, Parameters params, IEventQueue<DependencyManagingInstance, Double> queue) {
        this.model = model;
        this.queue = queue;
        this.context = new SimpleContext();
        this.exev = new BasicExpressionEvaluator();
        this.stev = new BasicStatementEvaluator();
        this.atd = new BasicActivationTimeDrawer();
        this.unqueued = new HashSet<DependencyManagingInstance>();
        this.tdm = new TypeDependencyMap(model);
        for (AgentDeclaration ad : model.getAgentDeclarations()) {
            this.atd.initializeRules(ad.getRules());
        }
        this.context.put((Object)IContext.Keys.AGENT_FACTORY, agentFactory);
        this.context.put((Object)IContext.Keys.STATE, this.state);
        this.context.put((Object)IContext.Keys.MODEL, model);
        this.context.put((Object)IContext.Keys.RANDOM, rng);
        this.context.put((Object)IContext.Keys.TIME, this.time);
        this.context.put((Object)IContext.Keys.EXPRESSION_EVALUATOR, this.exev);
        this.context.put((Object)IContext.Keys.STATEMENT_EVALUATOR, this.stev);
        this.context.put((Object)IContext.Keys.PARAMETERS, params);
        this.context.put((Object)IContext.Keys.CP_VISITOR, new ConstantPieceVisitor());
    }

    @Override
    public void run(IState initialState, double startTime, IStopCondition condition) {
        this.state = initialState;
        this.time = startTime;
        this.context.put((Object)IContext.Keys.STATE, this.state);
        this.context.put((Object)IContext.Keys.TIME, this.time);
        this.scheduleEverything();
        while (!condition.test(this.state, this.time) && !this.queue.isEmpty()) {
            Entry activatedEntry = this.queue.dequeue();
            DependencyManagingInstance activatedInstance = (DependencyManagingInstance)activatedEntry.getEvent();
            double activationTime = (Double)activatedEntry.getTime();
            this.execute(activatedInstance, activationTime);
        }
        this.finishAll(this.state, this.time);
    }

    private void scheduleEverything() {
        Collection<IAgent> agents = this.state.getAgentsAlive();
        for (IAgent agent : agents) {
            this.scheduleAgent(agent);
        }
    }

    private void scheduleAgent(IAgent agent) {
        AgentDeclaration type = this.model.getAgentDeclaration(agent.getType());
        Collection<Rule> rules = type.getRules();
        for (Rule rule : rules) {
            if (rule.getInstanciations().isEmpty()) {
                this.scheduleRuleInstance(new DependencyManagingInstance(rule, (DependencyManagingAgent)agent, this.tdm));
                continue;
            }
            this.scheduleForEach(new ForEachInstanceSet(rule, (DependencyManagingAgent)agent, this.tdm));
        }
    }

    private void scheduleForEach(ForEachInstanceSet instances) {
        IAgent agent = instances.getAgent();
        Rule rule = instances.getRule();
        instances.getInstances().stream().forEach(instance -> {
            instance.removeDependenciesToThis();
            this.remove((DependencyManagingInstance)instance);
        });
        instances.clearInstances();
        instances.removeDependenciesToThis();
        this.context.push();
        this.context.put((Object)IContext.Keys.EGO, new AgentValue(agent));
        Pair<ExpressionEvaluationProtocol, Collection<Map<String, IValue>>> foo = this.getForEachCandidateMaps(rule);
        ExpressionEvaluationProtocol protocol = foo.getFirstValue();
        instances.addDependenciesToThis(protocol.getDependencies(), protocol.getAliveDependencies(), protocol.getAgentTypeDependencies());
        for (Map<String, IValue> candidateSet : foo.getSecondValue()) {
            DependencyManagingInstance instance2 = new DependencyManagingInstance(rule, (DependencyManagingAgent)agent, this.tdm);
            for (String key : candidateSet.keySet()) {
                instance2.addForEach(key, candidateSet.get(key));
            }
            instances.addInstance(instance2);
            this.scheduleRuleInstance(instance2);
        }
        this.context.pop();
    }

    private void remove(DependencyManagingInstance instance) {
        boolean wasUnqueued = this.unqueued.remove(instance);
        if (!wasUnqueued) {
            this.queue.dequeue(instance);
        }
    }

    private void scheduleRuleInstance(DependencyManagingInstance instance) {
        instance.removeDependenciesToThis();
        IAgent agent = instance.getAgent();
        Rule rule = instance.getRule();
        if (!agent.isAlive()) {
            this.remove(instance);
            return;
        }
        this.context.push();
        this.context.put((Object)IContext.Keys.EGO, new AgentValue(agent));
        this.context.put((Object)IContext.Keys.RULE, rule);
        for (String key : rule.getVariables().keySet()) {
            this.context.put(key, rule.getVariables().get(key).getExpression());
        }
        for (String key : instance.getForEachs().keySet()) {
            this.context.put(key, instance.getForEachs().get(key));
        }
        instance.clearWheres();
        instance.addAliveDependenciesToThis(agent);
        ExpressionEvaluationProtocol guardP = this.exev.evaluate(rule.getGuard(), this.context);
        if (((BoolValue)guardP.getValue()).getValue().booleanValue()) {
            RateEvaluationProtocol activationTimeP = this.atd.drawActivationTimeAndProtocol(rule.getRate(), this.context);
            double activationTime = activationTimeP.getActivationTime();
            if (Double.isFinite(activationTime)) {
                this.unqueued.remove(instance);
                this.queue.requeue(instance, activationTime);
                instance.addDependenciesToThis(guardP.getDependencies(), guardP.getAliveDependencies(), guardP.getAgentTypeDependencies());
                instance.addDependenciesToThis(activationTimeP.getDependencies(), activationTimeP.getAliveDependencies(), activationTimeP.getAgentTypeDependencies());
                for (String key : rule.getVariables().keySet()) {
                    instance.addWhere(key, this.context.get(key));
                }
            } else {
                boolean wasQueued = this.unqueued.add(instance);
                if (wasQueued) {
                    this.queue.dequeue(instance);
                }
                instance.addDependenciesToThis(guardP.getDependencies(), guardP.getAliveDependencies(), guardP.getAgentTypeDependencies());
                instance.addDependenciesToThis(activationTimeP.getDependencies(), activationTimeP.getAliveDependencies(), activationTimeP.getAgentTypeDependencies());
            }
        } else {
            boolean wasQueued = this.unqueued.add(instance);
            if (wasQueued) {
                this.queue.dequeue(instance);
            }
            instance.addDependenciesToThis(guardP.getDependencies(), guardP.getAliveDependencies(), guardP.getAgentTypeDependencies());
        }
        this.context.pop();
    }

    private void execute(DependencyManagingInstance instance, double activationTime) {
        DependencyManagingAgent dmAgent;
        StatementEvaluationProtocol sep = this.executeInstance(instance, activationTime, this.model, this.state, this.context, this.time);
        this.atd.notifyExecution(instance.getRule().getID(), instance.getAgent().getID(), activationTime);
        this.time = activationTime;
        HashSet<DependencyManagingInstance> toReschedule = new HashSet<DependencyManagingInstance>();
        toReschedule.add(instance);
        HashSet<ForEachInstanceSet> toRescheduleForEachSets = new HashSet<ForEachInstanceSet>();
        for (AgentField field : sep.getChangedFields()) {
            dmAgent = (DependencyManagingAgent)field.getAgent();
            toReschedule.addAll(dmAgent.getDependencies(field.getField()));
            toRescheduleForEachSets.addAll(dmAgent.getDependentInstanceSets(field.getField()));
        }
        for (IAgent agent : sep.getKilledAgents()) {
            dmAgent = (DependencyManagingAgent)agent;
            toReschedule.addAll(dmAgent.getAliveDependencies());
            toReschedule.addAll(this.tdm.getAgentTypeDependencies(agent.getType()));
            toRescheduleForEachSets.addAll(dmAgent.getAliveDependentInstanceSets());
            toRescheduleForEachSets.addAll(this.tdm.getAgentTypeDependentInstanceSets(agent.getType()));
        }
        for (IAgent newAgent : sep.getCreatedAgents()) {
            toReschedule.addAll(this.tdm.getAgentTypeDependencies(newAgent.getType()));
            toRescheduleForEachSets.addAll(this.tdm.getAgentTypeDependentInstanceSets(newAgent.getType()));
        }
        for (DependencyManagingInstance rescheduledInstance : toReschedule) {
            this.scheduleRuleInstance(rescheduledInstance);
        }
        for (ForEachInstanceSet instanceSet : toRescheduleForEachSets) {
            this.scheduleForEach(instanceSet);
        }
        for (IAgent agent : sep.getCreatedAgents()) {
            this.scheduleAgent(agent);
        }
    }

    private Pair<ExpressionEvaluationProtocol, Collection<Map<String, IValue>>> getForEachCandidateMaps(Rule rule) {
        ArrayList<ExpressionEvaluationProtocol> protocols = new ArrayList<ExpressionEvaluationProtocol>();
        RuleInstanciation instanciation = rule.getInstanciations().values().iterator().next();
        String candidateName = instanciation.getCandidateName();
        ExpressionEvaluationProtocol protocol = this.exev.evaluate(instanciation.getCandidateExpression(), this.context);
        protocols.add(protocol);
        Object candidateSet = ((SetValue)protocol.getValue()).getValue();
        ArrayList instances = new ArrayList();
        Iterator iterator = candidateSet.iterator();
        while (iterator.hasNext()) {
            IValue candidate = (IValue)iterator.next();
            HashMap<String, IValue> map = new HashMap<String, IValue>();
            map.put(candidateName, candidate);
            instances.add(map);
        }
        return new Pair<ExpressionEvaluationProtocol, Collection<Map<String, IValue>>>(new ExpressionEvaluationProtocol(null, protocols), instances);
    }
}

