/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.simulator.simulators.frm;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.math3.random.RandomGenerator;
import org.jamesii.ml3.model.Model;
import org.jamesii.ml3.model.Parameters;
import org.jamesii.ml3.model.agents.AgentDeclaration;
import org.jamesii.ml3.model.agents.IAgent;
import org.jamesii.ml3.model.agents.IAgentFactory;
import org.jamesii.ml3.model.agents.rules.Rule;
import org.jamesii.ml3.model.agents.rules.rates.EverySynchronizedRate;
import org.jamesii.ml3.model.state.IState;
import org.jamesii.ml3.model.values.AgentValue;
import org.jamesii.ml3.model.values.BoolValue;
import org.jamesii.ml3.model.values.IValue;
import org.jamesii.ml3.simulator.context.IContext;
import org.jamesii.ml3.simulator.context.SimpleContext;
import org.jamesii.ml3.simulator.evaluate.BasicExpressionEvaluator;
import org.jamesii.ml3.simulator.evaluate.BasicStatementEvaluator;
import org.jamesii.ml3.simulator.exceptions.SimulationException;
import org.jamesii.ml3.simulator.rates.BasicActivationTimeDrawer;
import org.jamesii.ml3.simulator.rates.ConstantPieceVisitor;
import org.jamesii.ml3.simulator.simulators.AbstractSimulator;
import org.jamesii.ml3.simulator.simulators.RuleActivation;
import org.jamesii.ml3.simulator.simulators.RuleInstance;
import org.jamesii.ml3.simulator.stop.IStopCondition;
import org.jamesii.ml3.simulator.stop.StopConditions;

public class BasicFirstReactionSimulator
extends AbstractSimulator {
    private Model model;
    private IAgentFactory agentFactory;
    private RandomGenerator rng;
    private Parameters params;
    private double time;

    public BasicFirstReactionSimulator(Model model, IAgentFactory agentFactory, RandomGenerator rng, Parameters params) {
        this.model = model;
        this.agentFactory = agentFactory;
        this.rng = rng;
        this.params = params;
    }

    @Override
    public void run(IState initialState, double startTime, IStopCondition condition) {
        this.time = startTime;
        IState state = initialState;
        SimpleContext context = new SimpleContext();
        BasicExpressionEvaluator exev = new BasicExpressionEvaluator();
        BasicStatementEvaluator stev = new BasicStatementEvaluator();
        BasicActivationTimeDrawer atd = new BasicActivationTimeDrawer();
        for (AgentDeclaration ad : this.model.getAgentDeclarations()) {
            atd.initializeRules(ad.getRules());
        }
        context.put((Object)IContext.Keys.AGENT_FACTORY, this.agentFactory);
        context.put((Object)IContext.Keys.STATE, state);
        context.put((Object)IContext.Keys.MODEL, this.model);
        context.put((Object)IContext.Keys.RANDOM, this.rng);
        context.put((Object)IContext.Keys.EXPRESSION_EVALUATOR, exev);
        context.put((Object)IContext.Keys.STATEMENT_EVALUATOR, stev);
        context.put((Object)IContext.Keys.PARAMETERS, this.params);
        context.put((Object)IContext.Keys.CP_VISITOR, new ConstantPieceVisitor());
        while (!condition.test(state, this.time) && !StopConditions.ALL_DEAD.test(state, this.time)) {
            context.put((Object)IContext.Keys.TIME, this.time);
            RuleActivation activation = null;
            Collection<IAgent> agents = state.getAgentsAlive();
            for (IAgent agent : agents) {
                context.push();
                context.put((Object)IContext.Keys.EGO, new AgentValue(agent));
                AgentDeclaration type = this.model.getAgentDeclaration(agent.getType());
                Collection<Rule> rules = type.getRules();
                for (Rule rule : rules) {
                    context.push();
                    context.put((Object)IContext.Keys.RULE, rule);
                    Collection<Map<String, Object>> variableInstances = this.getAllInstances(rule, context);
                    for (Map<String, Object> instance : variableInstances) {
                        double activationTime;
                        context.push();
                        for (String variable : instance.keySet()) {
                            context.put(variable, instance.get(variable));
                        }
                        if (((BoolValue)exev.getValue(rule.getGuard(), context)).getValue().booleanValue() && Double.isFinite(activationTime = atd.drawActivationTime(rule.getRate(), context)) && (activation == null || activationTime < activation.getActivationTime())) {
                            activation = new RuleActivation(rule.getID(), agent.getID(), activationTime);
                            for (String variable : instance.keySet()) {
                                activation.getVariables().put(variable, context.get(variable));
                            }
                        }
                        context.pop();
                    }
                    context.pop();
                }
                context.pop();
            }
            if (activation == null) break;
            IAgent agent = state.getAgent(activation.getAgentID());
            Rule rule = this.model.getAgentDeclaration(agent.getType()).getRule(activation.getRuleID());
            RuleInstance instance = this.getRuleInstance(activation, state);
            if (rule.getRate() instanceof EverySynchronizedRate) {
                Collection<IAgent> sameTypeAgents = state.getAgentsAliveByType(agent.getType());
                for (IAgent sameTypeAgent : sameTypeAgents) {
                    RuleActivation thisActivation = new RuleActivation(activation.getRuleID(), sameTypeAgent.getID(), activation.getActivationTime());
                    for (String variable : rule.getVariables().keySet()) {
                        thisActivation.getVariables().put(variable, rule.getVariables().get(variable).getExpression());
                    }
                    RuleInstance thisInstance = this.getRuleInstance(activation, state);
                    this.executeInstance(thisInstance, activation.getActivationTime(), this.model, state, context, this.time);
                    atd.notifyExecution(thisInstance.getRule().getID(), thisInstance.getAgent().getID(), activation.getActivationTime());
                }
            } else {
                this.executeInstance(instance, activation.getActivationTime(), this.model, state, context, this.time);
                atd.notifyExecution(activation.getRuleID(), activation.getAgentID(), activation.getActivationTime());
            }
            this.time = activation.getActivationTime();
        }
        this.finishAll(state, this.time);
    }

    private RuleInstance getRuleInstance(RuleActivation activation, IState state) {
        IAgent agent = state.getAgent(activation.getAgentID());
        Rule rule = this.model.getAgentDeclaration(agent.getType()).getRule(activation.getRuleID());
        RuleInstance instance = new RuleInstance(rule, agent);
        for (String variable : activation.getVariables().keySet()) {
            if (rule.getInstanciations().containsKey(variable)) {
                instance.addForEach(variable, (IValue)activation.getVariables().get(variable));
                continue;
            }
            if (rule.getVariables().containsKey(variable)) {
                instance.addWhere(variable, activation.getVariables().get(variable));
                continue;
            }
            throw new SimulationException("Should never happen.");
        }
        return instance;
    }
}

