/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.simulator.simulators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jamesii.ml3.model.Model;
import org.jamesii.ml3.model.agents.IAgent;
import org.jamesii.ml3.model.agents.rules.Rule;
import org.jamesii.ml3.model.agents.rules.RuleInstanciation;
import org.jamesii.ml3.model.state.IState;
import org.jamesii.ml3.model.state.UnmodifiableState;
import org.jamesii.ml3.model.values.AgentValue;
import org.jamesii.ml3.model.values.IValue;
import org.jamesii.ml3.model.values.SetValue;
import org.jamesii.ml3.observation.IObserver;
import org.jamesii.ml3.simulator.context.IContext;
import org.jamesii.ml3.simulator.evaluate.IExpressionEvaluator;
import org.jamesii.ml3.simulator.evaluate.IStatementEvaluator;
import org.jamesii.ml3.simulator.evaluate.StatementEvaluationProtocol;
import org.jamesii.ml3.simulator.simulators.ISimulator;
import org.jamesii.ml3.simulator.simulators.RuleInstance;

public abstract class AbstractSimulator
implements ISimulator {
    private Collection<IObserver> observers = new ArrayList<IObserver>();

    @Override
    public void addObserver(IObserver observer) {
        this.observers.add(observer);
    }

    protected void updateBeforeAll(IState oldState, double now, double timeOfNextEvent, RuleInstance instance) {
        UnmodifiableState unmodifiable = new UnmodifiableState(oldState);
        for (IObserver observer : this.observers) {
            observer.updateBefore(unmodifiable, now, timeOfNextEvent, instance);
        }
    }

    protected void updateAfterAll(IState newState, double timeOfNextEvent, RuleInstance instance, StatementEvaluationProtocol sep) {
        UnmodifiableState unmodifiable = new UnmodifiableState(newState);
        for (IObserver observer : this.observers) {
            observer.updateAfter(unmodifiable, timeOfNextEvent, instance, sep);
        }
    }

    protected void finishAll(IState state, double now) {
        UnmodifiableState unmodifiable = new UnmodifiableState(state);
        for (IObserver observer : this.observers) {
            observer.finish(unmodifiable, now);
        }
    }

    protected Collection<Map<String, Object>> getAllInstances(Rule rule, IContext context) {
        if (rule.getInstanciations().isEmpty()) {
            return Collections.singleton(this.newVariableMap(rule));
        }
        HashMap<String, Collection<IValue>> variableInstances = new HashMap<String, Collection<IValue>>();
        for (RuleInstanciation instanciation : rule.getInstanciations().values()) {
            variableInstances.put(instanciation.getCandidateName(), this.getValues(instanciation, context));
        }
        ArrayList<Map<String, Object>> instances = new ArrayList<Map<String, Object>>();
        instances.add(this.newVariableMap(rule));
        for (String variable : variableInstances.keySet()) {
            ArrayList newInstances = new ArrayList();
            for (Map map : instances) {
                for (IValue value : (Set)variableInstances.get(variable)) {
                    HashMap<String, IValue> newInstance = new HashMap<String, IValue>();
                    newInstance.putAll(map);
                    newInstance.put(variable, value);
                    newInstances.add(newInstance);
                }
            }
            instances = newInstances;
        }
        return instances;
    }

    private Collection<IValue> getValues(RuleInstanciation ri, IContext context) {
        IExpressionEvaluator exev = (IExpressionEvaluator)context.get((Object)IContext.Keys.EXPRESSION_EVALUATOR);
        Object ret = ((SetValue)exev.getValue(ri.getCandidateExpression(), context)).getValue();
        return ret;
    }

    private Map<String, Object> newVariableMap(Rule rule) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : rule.getVariables().keySet()) {
            map.put(key, rule.getVariables().get(key).getExpression());
        }
        return map;
    }

    protected StatementEvaluationProtocol executeInstance(RuleInstance instance, double activationTime, Model model, IState state, IContext context, double now) {
        IStatementEvaluator stev = (IStatementEvaluator)context.get((Object)IContext.Keys.STATEMENT_EVALUATOR);
        this.updateBeforeAll(state, now, activationTime, instance);
        IAgent agent = instance.getAgent();
        Rule rule = instance.getRule();
        context.put((Object)IContext.Keys.TIME, activationTime);
        context.push();
        context.put((Object)IContext.Keys.EGO, new AgentValue(agent));
        for (String variable : instance.getWheres().keySet()) {
            context.put(variable, instance.getWheres().get(variable));
        }
        for (String variable : instance.getForEachs().keySet()) {
            context.put(variable, instance.getForEachs().get(variable));
        }
        StatementEvaluationProtocol sep = stev.evaluate(rule.getEffect(), context);
        context.pop();
        this.updateAfterAll(state, activationTime, instance, sep);
        return sep;
    }
}

