/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.simulator.rates;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jamesii.ml3.model.agents.AgentField;
import org.jamesii.ml3.model.agents.IAgent;
import org.jamesii.ml3.simulator.evaluate.ExpressionEvaluationProtocol;

public class RateEvaluationProtocol {
    private double activationTime;
    private Set<AgentField> fields;
    private Set<String> agentTypes;
    private Set<IAgent> alives;

    public RateEvaluationProtocol(double activationTime, ExpressionEvaluationProtocol ... dependencies) {
        this.activationTime = activationTime;
        this.fields = new HashSet<AgentField>();
        this.agentTypes = new HashSet<String>();
        this.alives = new HashSet<IAgent>();
        for (ExpressionEvaluationProtocol dependency : dependencies) {
            this.fields.addAll(dependency.getDependencies());
            this.agentTypes.addAll(dependency.getAgentTypeDependencies());
            this.alives.addAll(dependency.getAliveDependencies());
        }
    }

    public RateEvaluationProtocol(double activationTime, Collection<ExpressionEvaluationProtocol> dependencies) {
        this.activationTime = activationTime;
        this.fields = new HashSet<AgentField>();
        this.agentTypes = new HashSet<String>();
        this.alives = new HashSet<IAgent>();
        for (ExpressionEvaluationProtocol dependency : dependencies) {
            this.fields.addAll(dependency.getDependencies());
            this.agentTypes.addAll(dependency.getAgentTypeDependencies());
            this.alives.addAll(dependency.getAliveDependencies());
        }
    }

    public double getActivationTime() {
        return this.activationTime;
    }

    public Set<AgentField> getDependencies() {
        return this.fields;
    }

    public void setDependencies(Set<AgentField> fields) {
        this.fields = fields;
    }

    public void addDependency(IAgent agent, String field) {
        this.fields.add(new AgentField(agent, field));
    }

    public void addAgentTypeDependency(String type) {
        this.agentTypes.add(type);
    }

    public Set<String> getAgentTypeDependencies() {
        return this.agentTypes;
    }

    public void setAgentTypeDependencies(Set<String> agentTypes) {
        this.agentTypes = agentTypes;
    }

    public Set<IAgent> getAliveDependencies() {
        return this.alives;
    }

    public void setAliveDependencies(Set<IAgent> alives) {
        this.alives = alives;
    }

    public void addAliveDependency(IAgent agent) {
        this.alives.add(agent);
    }
}

