/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.simulator.rates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jamesii.ml3.model.Model;
import org.jamesii.ml3.model.Parameters;
import org.jamesii.ml3.model.agents.FunctionDefinition;
import org.jamesii.ml3.model.agents.IAgent;
import org.jamesii.ml3.model.agents.rules.VariableBinding;
import org.jamesii.ml3.model.maps.ContinuousValueMap;
import org.jamesii.ml3.model.validation.BasicTimeDependencyValidator;
import org.jamesii.ml3.model.validation.ITimeDependencyValidator;
import org.jamesii.ml3.model.validation.TimeDependency;
import org.jamesii.ml3.model.values.AgentValue;
import org.jamesii.ml3.model.values.BoolValue;
import org.jamesii.ml3.model.values.IValue;
import org.jamesii.ml3.model.values.IntValue;
import org.jamesii.ml3.model.values.RealValue;
import org.jamesii.ml3.model.values.SetValue;
import org.jamesii.ml3.parser.nodes.expressions.AbstractExpressionVisitor;
import org.jamesii.ml3.parser.nodes.expressions.AddExpression;
import org.jamesii.ml3.parser.nodes.expressions.AttributeAccessExpression;
import org.jamesii.ml3.parser.nodes.expressions.ConditionalExpression;
import org.jamesii.ml3.parser.nodes.expressions.DivideExpression;
import org.jamesii.ml3.parser.nodes.expressions.ErrorExpression;
import org.jamesii.ml3.parser.nodes.expressions.ExponentialExpression;
import org.jamesii.ml3.parser.nodes.expressions.FunctionCallExpression;
import org.jamesii.ml3.parser.nodes.expressions.IExpression;
import org.jamesii.ml3.parser.nodes.expressions.IExpressionVisitor;
import org.jamesii.ml3.parser.nodes.expressions.MapConstantAccessExpression;
import org.jamesii.ml3.parser.nodes.expressions.ModuloExpression;
import org.jamesii.ml3.parser.nodes.expressions.MultiplyExpression;
import org.jamesii.ml3.parser.nodes.expressions.NowExpression;
import org.jamesii.ml3.parser.nodes.expressions.RelationalExpression;
import org.jamesii.ml3.parser.nodes.expressions.UnaryExpression;
import org.jamesii.ml3.simulator.context.IContext;
import org.jamesii.ml3.simulator.evaluate.IExpressionEvaluator;
import org.jamesii.ml3.simulator.exceptions.SimulationException;
import org.jamesii.ml3.simulator.rates.ConstantPieceDescription;

public class ConstantPieceVisitor {
    private IExpressionVisitor<ConstantPieceDescription, IContext> visitor = new AbstractExpressionVisitor<ConstantPieceDescription, IContext>(){
        private ITimeDependencyValidator tdv = new BasicTimeDependencyValidator();

        private boolean isTimeIndependentAgentsAge(IExpression e) {
            if (e instanceof AttributeAccessExpression) {
                AttributeAccessExpression access = (AttributeAccessExpression)e;
                return !this.tdv.isTimeDependent(access.getBaseExpression(), null) && access.getAttributeName().equals("age");
            }
            return false;
        }

        @Override
        public ConstantPieceDescription visit(MapConstantAccessExpression e, IContext c) {
            IExpressionEvaluator exev = (IExpressionEvaluator)c.get((Object)IContext.Keys.EXPRESSION_EVALUATOR);
            Model m = (Model)c.get((Object)IContext.Keys.MODEL);
            if (!this.tdv.isTimeDependent(e.getParameter(), m)) {
                return new ConstantPieceDescription();
            }
            Parameters params = (Parameters)c.get((Object)IContext.Keys.PARAMETERS);
            ContinuousValueMap map = (ContinuousValueMap)params.getValueMap(e.getMapName());
            if (e.getParameter() instanceof NowExpression) {
                return new ConstantPieceDescription(map.getBorders());
            }
            if (this.isTimeIndependentAgentsAge(e.getParameter())) {
                AttributeAccessExpression aae = (AttributeAccessExpression)e.getParameter();
                IAgent agent = ((AgentValue)exev.getValue(aae.getBaseExpression(), c)).getValue();
                double birth = agent.getTimeOfBirth();
                return new ConstantPieceDescription(map.getBorders(birth));
            }
            throw new RuntimeException("Illegal rate expression: " + e);
        }

        @Override
        public ConstantPieceDescription visit(ConditionalExpression e, IContext c) {
            IExpressionEvaluator exev = (IExpressionEvaluator)c.get((Object)IContext.Keys.EXPRESSION_EVALUATOR);
            Model m = (Model)c.get((Object)IContext.Keys.MODEL);
            TimeDependency td = this.tdv.getTimeDependency(e.getCondition(), m);
            if (td == TimeDependency.CONSTANT) {
                boolean cond = ((BoolValue)exev.getValue(e.getCondition(), c)).getValue();
                if (cond) {
                    return ConstantPieceVisitor.this.getConstantPieces(e.getThenExpression(), c);
                }
                return ConstantPieceVisitor.this.getConstantPieces(e.getElseExpression(), c);
            }
            if (e.getCondition() instanceof RelationalExpression) {
                IValue rightValue;
                RelationalExpression cond = (RelationalExpression)e.getCondition();
                boolean isLower = cond.getOperator().equals((Object)RelationalExpression.RelationalOperator.L) || cond.getOperator().equals((Object)RelationalExpression.RelationalOperator.LEQ);
                IExpression left = null;
                IExpression right = null;
                if (cond.getLeftExpression() instanceof NowExpression || this.isTimeIndependentAgentsAge(cond.getLeftExpression())) {
                    left = cond.getLeftExpression();
                    right = cond.getRightExpression();
                } else if (cond.getRightExpression() instanceof NowExpression || this.isTimeIndependentAgentsAge(cond.getRightExpression())) {
                    right = cond.getLeftExpression();
                    left = cond.getRightExpression();
                    boolean bl = isLower = !isLower;
                }
                if (this.tdv.isTimeDependent(right, m)) {
                    throw new RuntimeException("Illegal rate expression.");
                }
                double agentBirth = 0.0;
                if (left instanceof AttributeAccessExpression) {
                    AttributeAccessExpression aae = (AttributeAccessExpression)left;
                    IAgent agent = ((AgentValue)exev.getValue(aae.getBaseExpression(), c)).getValue();
                    agentBirth = agent.getTimeOfBirth();
                }
                double changeTime = ((rightValue = exev.getValue(right, c)) instanceof IntValue ? (double)((IntValue)rightValue).getValue().intValue() : ((RealValue)rightValue).getValue()) + agentBirth;
                ConstantPieceDescription thenCP = ConstantPieceVisitor.this.getConstantPieces(e.getThenExpression(), c);
                ConstantPieceDescription elseCP = ConstantPieceVisitor.this.getConstantPieces(e.getElseExpression(), c);
                if (isLower) {
                    return ConstantPieceDescription.merge(thenCP, changeTime, elseCP);
                }
                return ConstantPieceDescription.merge(elseCP, changeTime, thenCP);
            }
            if (td == TimeDependency.PIECEWISE_CONSTANT) {
                ConstantPieceDescription condCP = ConstantPieceVisitor.this.getConstantPieces(e.getCondition(), c);
                ConstantPieceDescription thenCP = ConstantPieceVisitor.this.getConstantPieces(e.getThenExpression(), c);
                ConstantPieceDescription elseCP = ConstantPieceVisitor.this.getConstantPieces(e.getElseExpression(), c);
                return ConstantPieceDescription.merge(condCP, thenCP, elseCP);
            }
            throw new RuntimeException("Illegal rate expression.");
        }

        @Override
        public ConstantPieceDescription visit(AddExpression e, IContext c) {
            ConstantPieceDescription left = ConstantPieceVisitor.this.getConstantPieces(e.getLeftSummand(), c);
            ConstantPieceDescription right = ConstantPieceVisitor.this.getConstantPieces(e.getRightSummand(), c);
            return ConstantPieceDescription.merge(left, right);
        }

        @Override
        public ConstantPieceDescription visit(MultiplyExpression e, IContext c) {
            ConstantPieceDescription left = ConstantPieceVisitor.this.getConstantPieces(e.getLeftFactor(), c);
            ConstantPieceDescription right = ConstantPieceVisitor.this.getConstantPieces(e.getRightFactor(), c);
            return ConstantPieceDescription.merge(left, right);
        }

        @Override
        public ConstantPieceDescription visit(DivideExpression e, IContext c) {
            ConstantPieceDescription left = ConstantPieceVisitor.this.getConstantPieces(e.getDividend(), c);
            ConstantPieceDescription right = ConstantPieceVisitor.this.getConstantPieces(e.getDivisor(), c);
            return ConstantPieceDescription.merge(left, right);
        }

        @Override
        public ConstantPieceDescription visit(ModuloExpression e, IContext c) {
            ConstantPieceDescription left = ConstantPieceVisitor.this.getConstantPieces(e.getDividend(), c);
            ConstantPieceDescription right = ConstantPieceVisitor.this.getConstantPieces(e.getDivisor(), c);
            return ConstantPieceDescription.merge(left, right);
        }

        @Override
        public ConstantPieceDescription visit(ExponentialExpression e, IContext c) {
            ConstantPieceDescription left = ConstantPieceVisitor.this.getConstantPieces(e.getBase(), c);
            ConstantPieceDescription right = ConstantPieceVisitor.this.getConstantPieces(e.getExponent(), c);
            return ConstantPieceDescription.merge(left, right);
        }

        @Override
        public ConstantPieceDescription visit(UnaryExpression e, IContext c) {
            return ConstantPieceVisitor.this.getConstantPieces(e.getExpression(), c);
        }

        @Override
        public ConstantPieceDescription visit(FunctionCallExpression e, IContext c) {
            Model m = (Model)c.get((Object)IContext.Keys.MODEL);
            IExpressionEvaluator exev = (IExpressionEvaluator)c.get((Object)IContext.Keys.EXPRESSION_EVALUATOR);
            Collection args = e.getParameters().stream().map(e1 -> ConstantPieceVisitor.this.getConstantPieces((IExpression)e1, c)).collect(Collectors.toList());
            if (e.getBaseExpression() == null) {
                return ConstantPieceDescription.merge(args);
            }
            IValue left = exev.getValue(e.getBaseExpression(), c);
            ConstantPieceDescription leftCP = ConstantPieceVisitor.this.getConstantPieces(e.getBaseExpression(), c);
            if (left instanceof AgentValue) {
                IAgent agent = ((AgentValue)left).getValue();
                if (e.getFunctionName().equals("isAlive")) {
                    return leftCP;
                }
                if (e.getFunctionName().startsWith("has")) {
                    return leftCP;
                }
                FunctionDefinition funDef = m.getAgentDeclaration(agent.getType()).getFunction(e.getFunctionName());
                List<String> paramNames = funDef.getParameterNames();
                ArrayList<IValue> paramValues = new ArrayList<IValue>(e.getParameters().size());
                for (IExpression exp : e.getParameters()) {
                    paramValues.add(exev.getValue(exp, c));
                }
                c.push();
                c.put((Object)IContext.Keys.EGO, new AgentValue(agent));
                for (int i = 0; i < paramNames.size(); ++i) {
                    c.put(paramNames.get(i), paramValues.get(i));
                }
                for (VariableBinding var : funDef.getVariableBindings()) {
                    c.put(var.getVariable(), var.getExpression());
                }
                ConstantPieceDescription def = ConstantPieceVisitor.this.getConstantPieces(funDef.getExpression(), c);
                c.pop();
                return ConstantPieceDescription.merge(leftCP, def, ConstantPieceDescription.merge(args));
            }
            if (left instanceof SetValue) {
                return ConstantPieceDescription.merge(args);
            }
            throw new SimulationException("Invalid function call.");
        }

        @Override
        public ConstantPieceDescription visit(RelationalExpression e, IContext c) {
            return ConstantPieceDescription.merge(ConstantPieceVisitor.this.getConstantPieces(e.getLeftExpression(), c), ConstantPieceVisitor.this.getConstantPieces(e.getRightExpression(), c));
        }

        @Override
        protected ConstantPieceDescription visitDefault(IExpression e, IContext c) {
            Model m = (Model)c.get((Object)IContext.Keys.MODEL);
            if (!this.tdv.isTimeDependent(e, m)) {
                return new ConstantPieceDescription();
            }
            throw new RuntimeException("Illegal rate expression.");
        }

        @Override
        public ConstantPieceDescription visit(ErrorExpression e, IContext p) {
            return new ConstantPieceDescription();
        }
    };

    public ConstantPieceDescription getConstantPieces(IExpression e, IContext c) {
        return e.accept(this.visitor, c);
    }
}

