/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.simulator.rates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;

public class ConstantPieceDescription {
    private TreeSet<Double> changepoints;

    public ConstantPieceDescription() {
        this.changepoints = new TreeSet();
    }

    public ConstantPieceDescription(List<Double> changepoints) {
        this.changepoints = new TreeSet();
        this.changepoints.addAll(changepoints);
    }

    public ConstantPieceDescription(TreeSet<Double> changepoints) {
        this.changepoints = changepoints;
    }

    public TreeSet<Double> getChangepoints() {
        return this.changepoints;
    }

    public List<Double> getChangepointList() {
        ArrayList<Double> list = new ArrayList<Double>(this.changepoints.size());
        for (Double t : this.changepoints) {
            list.add(t);
        }
        return list;
    }

    public static ConstantPieceDescription merge(ConstantPieceDescription lower, double change, ConstantPieceDescription upper) {
        TreeSet<Double> changepoints = new TreeSet<Double>();
        lower.getChangepoints().headSet(change);
        changepoints.addAll(lower.getChangepoints().headSet(change));
        changepoints.add(change);
        changepoints.addAll(upper.getChangepoints().tailSet(change));
        return new ConstantPieceDescription(changepoints);
    }

    public static ConstantPieceDescription merge(ConstantPieceDescription ... cpds) {
        TreeSet<Double> changepoints = new TreeSet<Double>();
        for (int i = 0; i < cpds.length; ++i) {
            changepoints.addAll(cpds[i].getChangepoints());
        }
        return new ConstantPieceDescription(changepoints);
    }

    public static ConstantPieceDescription merge(Collection<ConstantPieceDescription> cpds) {
        TreeSet<Double> changepoints = new TreeSet<Double>();
        for (ConstantPieceDescription cpd : cpds) {
            changepoints.addAll(cpd.getChangepoints());
        }
        return new ConstantPieceDescription(changepoints);
    }
}

