/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.simulator.rates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.random.RandomGenerator;
import org.jamesii.core.util.misc.Pair;
import org.jamesii.ml3.model.agents.IAgent;
import org.jamesii.ml3.model.agents.rules.Rule;
import org.jamesii.ml3.model.agents.rules.rates.AgeRate;
import org.jamesii.ml3.model.agents.rules.rates.EveryRate;
import org.jamesii.ml3.model.agents.rules.rates.EverySynchronizedRate;
import org.jamesii.ml3.model.agents.rules.rates.IRate;
import org.jamesii.ml3.model.agents.rules.rates.IRateVisitor;
import org.jamesii.ml3.model.agents.rules.rates.InstantlyRate;
import org.jamesii.ml3.model.agents.rules.rates.PiecewiseConstantRate;
import org.jamesii.ml3.model.agents.rules.rates.TimeIndependentRate;
import org.jamesii.ml3.model.values.AgentValue;
import org.jamesii.ml3.model.values.INumericalValue;
import org.jamesii.ml3.model.values.IValue;
import org.jamesii.ml3.model.values.IntValue;
import org.jamesii.ml3.model.values.RealValue;
import org.jamesii.ml3.parser.nodes.expressions.IExpression;
import org.jamesii.ml3.simulator.context.IContext;
import org.jamesii.ml3.simulator.evaluate.ExpressionEvaluationProtocol;
import org.jamesii.ml3.simulator.evaluate.IExpressionEvaluator;
import org.jamesii.ml3.simulator.rates.ConstantPieceDescription;
import org.jamesii.ml3.simulator.rates.ConstantPieceVisitor;
import org.jamesii.ml3.simulator.rates.IActivationTimeDrawer;
import org.jamesii.ml3.simulator.rates.RateEvaluationProtocol;

public class BasicActivationTimeDrawer
implements IActivationTimeDrawer {
    private static final double EPSILON = 1.0E-5;
    private final Map<Integer, Map<Integer, Double>> lastEvents = new HashMap<Integer, Map<Integer, Double>>();
    private IRateVisitor<RateEvaluationProtocol, IContext> visitor = new IRateVisitor<RateEvaluationProtocol, IContext>(){

        @Override
        public RateEvaluationProtocol visit(AgeRate r, IContext c) {
            IAgent ego = ((AgentValue)c.get((Object)IContext.Keys.EGO)).getValue();
            IExpressionEvaluator exev = (IExpressionEvaluator)c.get((Object)IContext.Keys.EXPRESSION_EVALUATOR);
            double now = (Double)c.get((Object)IContext.Keys.TIME);
            ExpressionEvaluationProtocol targetP = exev.evaluate(r.getTargetAgeExpression(), c);
            IValue targetValue = targetP.getValue();
            double targetDouble = 0.0;
            if (targetValue instanceof RealValue) {
                targetDouble = ((RealValue)targetValue).getValue();
            } else if (targetValue instanceof IntValue) {
                targetDouble = ((IntValue)targetValue).getValue().intValue();
            } else {
                throw new RuntimeException("Target age expression of AtAgeRate evaluated to something not numerical.");
            }
            double time = ego.getTimeOfBirth() + targetDouble;
            time = time >= now ? time : Double.POSITIVE_INFINITY;
            return new RateEvaluationProtocol(time, targetP);
        }

        @Override
        public RateEvaluationProtocol visit(InstantlyRate r, IContext c) {
            return new RateEvaluationProtocol((double)((Double)c.get((Object)IContext.Keys.TIME)), new ExpressionEvaluationProtocol[0]);
        }

        @Override
        public RateEvaluationProtocol visit(TimeIndependentRate r, IContext c) {
            IExpressionEvaluator exev = (IExpressionEvaluator)c.get((Object)IContext.Keys.EXPRESSION_EVALUATOR);
            RandomGenerator rng = (RandomGenerator)c.get((Object)IContext.Keys.RANDOM);
            double now = (Double)c.get((Object)IContext.Keys.TIME);
            ExpressionEvaluationProtocol rateP = exev.evaluate(r.getRateExpression(), c);
            IValue rateValue = rateP.getValue();
            double rate = rateValue instanceof RealValue ? ((RealValue)rateValue).getValue() : (rateValue instanceof IntValue ? 0.0 + (double)((IntValue)rateValue).getValue().intValue() : 0.0);
            if (rate > 0.0) {
                double rnd = rng.nextDouble();
                double deltaT = 1.0 / rate * Math.log(1.0 / rnd);
                return new RateEvaluationProtocol(now + Math.max(deltaT, 1.0E-5), rateP);
            }
            return new RateEvaluationProtocol(Double.POSITIVE_INFINITY, rateP);
        }

        @Override
        public RateEvaluationProtocol visit(PiecewiseConstantRate r, IContext c) {
            double now = (Double)c.get((Object)IContext.Keys.TIME);
            RandomGenerator rng = (RandomGenerator)c.get((Object)IContext.Keys.RANDOM);
            ConstantPieceVisitor cpFinder = (ConstantPieceVisitor)c.get((Object)IContext.Keys.CP_VISITOR);
            ConstantPieceDescription cps = cpFinder.getConstantPieces(r.getRateExpression(), c);
            double rnd = rng.nextDouble();
            double ln = Math.log(1.0 / rnd);
            List<Double> ts = cps.getChangepointList();
            List<RateValue> cs = this.getValues(r.getRateExpression(), c, ts);
            int nullIndex = this.getNullIndex(now, ts);
            if (nullIndex == ts.size()) {
                double deltaT = 1.0 / cs.get(nullIndex).getValue() * ln;
                return new RateEvaluationProtocol(now + Math.max(deltaT, 1.0E-5), this.collectEvaluationProtocols(cs, nullIndex));
            }
            Pair<Integer, Double> kAndSum = this.getSum(now, ln, ts, cs, nullIndex);
            int k = kAndSum.getFirstValue();
            double sum = kAndSum.getSecondValue();
            if (k == nullIndex - 1) {
                double deltaT = 1.0 / cs.get(nullIndex).getValue() * ln;
                return new RateEvaluationProtocol(now + Math.max(deltaT, 1.0E-5), this.collectEvaluationProtocols(cs, nullIndex));
            }
            double newTime = 1.0 / cs.get(k + 1).getValue() * (ln - sum) + ts.get(k);
            return new RateEvaluationProtocol(Math.max(newTime, now + 1.0E-5), this.collectEvaluationProtocols(cs, nullIndex));
        }

        private ExpressionEvaluationProtocol collectEvaluationProtocols(List<RateValue> cs, int nullIndex) {
            RateValue rv;
            if (cs.isEmpty()) {
                return new ExpressionEvaluationProtocol(null, new ExpressionEvaluationProtocol[0]);
            }
            ExpressionEvaluationProtocol p = new ExpressionEvaluationProtocol(null, new ExpressionEvaluationProtocol[0]);
            for (int i = nullIndex; i < cs.size() && (rv = cs.get(i)).evaluated; ++i) {
                p = new ExpressionEvaluationProtocol(null, rv.valueP, p);
            }
            return p;
        }

        private int getNullIndex(double now, List<Double> ts) {
            for (int i = 0; i < ts.size(); ++i) {
                if (!(now < ts.get(i))) continue;
                return i;
            }
            return ts.size();
        }

        private Pair<Integer, Double> getSum(double now, double ln, List<Double> ts, List<RateValue> cs, int nullIndex) {
            double sum = cs.get(nullIndex).getValue() * (ts.get(nullIndex) - now);
            if (sum > ln) {
                return new Pair<Integer, Double>(nullIndex - 1, 0.0);
            }
            for (int i = nullIndex + 1; i < ts.size(); ++i) {
                double oldSum = sum;
                if (!((sum += cs.get(i).getValue() * (ts.get(i) - ts.get(i - 1))) > ln)) continue;
                return new Pair<Integer, Double>(i - 1, oldSum);
            }
            return new Pair<Integer, Double>(ts.size() - 1, sum);
        }

        private List<RateValue> getValues(IExpression e, IContext c, List<Double> ts) {
            IExpressionEvaluator exev = (IExpressionEvaluator)c.get((Object)IContext.Keys.EXPRESSION_EVALUATOR);
            ArrayList<RateValue> values = new ArrayList<RateValue>(ts.size() + 1);
            if (ts.isEmpty()) {
                values.add(new RateValue(e, 0.0, exev, c));
            } else {
                values.add(new RateValue(e, Math.nextAfter(ts.get(0), Double.NEGATIVE_INFINITY), exev, c));
                for (double t : ts) {
                    values.add(new RateValue(e, Math.nextAfter(t, t + 1.0), exev, c));
                }
            }
            return values;
        }

        @Override
        public RateEvaluationProtocol visit(EveryRate r, IContext c) {
            IExpressionEvaluator exev = (IExpressionEvaluator)c.get((Object)IContext.Keys.EXPRESSION_EVALUATOR);
            double time = (Double)c.get((Object)IContext.Keys.TIME);
            IAgent ego = ((AgentValue)c.get((Object)IContext.Keys.EGO)).getValue();
            ExpressionEvaluationProtocol intervalP = exev.evaluate(r.getIntervalExpression(), c);
            IValue intervalValue = intervalP.getValue();
            double interval = 0.0;
            if (!(intervalValue instanceof INumericalValue)) {
                throw new RuntimeException("Interval expression of EveryRate evaluated to something not numerical.");
            }
            interval = ((INumericalValue)intervalValue).getDouble();
            double age = ego.getAge(time);
            int nextK = (int)Math.ceil(age / interval);
            double nextT = (double)nextK * interval + ego.getTimeOfBirth();
            Double lastT = (Double)((Map)BasicActivationTimeDrawer.this.lastEvents.get(((Rule)c.get((Object)IContext.Keys.RULE)).getID())).get(ego.getID());
            if (lastT == null) {
                lastT = Double.NEGATIVE_INFINITY;
            }
            if (nextT > lastT + 1.0E-5) {
                return new RateEvaluationProtocol(nextT, intervalP);
            }
            return new RateEvaluationProtocol(nextT + interval, intervalP);
        }

        @Override
        public RateEvaluationProtocol visit(EverySynchronizedRate r, IContext c) {
            IExpressionEvaluator exev = (IExpressionEvaluator)c.get((Object)IContext.Keys.EXPRESSION_EVALUATOR);
            double time = (Double)c.get((Object)IContext.Keys.TIME);
            IAgent ego = ((AgentValue)c.get((Object)IContext.Keys.EGO)).getValue();
            ExpressionEvaluationProtocol intervalP = exev.evaluate(r.getIntervalExpression(), c);
            IValue intervalValue = intervalP.getValue();
            double interval = 0.0;
            if (!(intervalValue instanceof INumericalValue)) {
                throw new RuntimeException("Interval expression of EveryRate evaluated to something not numerical.");
            }
            interval = ((INumericalValue)intervalValue).getDouble();
            int nextK = (int)Math.ceil(time / interval);
            double nextT = (double)nextK * interval;
            Double lastT = (Double)((Map)BasicActivationTimeDrawer.this.lastEvents.get(((Rule)c.get((Object)IContext.Keys.RULE)).getID())).get(ego.getID());
            if (lastT == null) {
                lastT = Double.NEGATIVE_INFINITY;
            }
            if (nextT > lastT + 1.0E-5) {
                return new RateEvaluationProtocol(nextT, intervalP);
            }
            return new RateEvaluationProtocol(nextT + interval, intervalP);
        }

        class RateValue {
            private IExpression expression;
            private double time;
            private ExpressionEvaluationProtocol valueP;
            private double value;
            private IExpressionEvaluator exev;
            private IContext c;
            private boolean evaluated;

            public RateValue(IExpression expression, double time, IExpressionEvaluator exev, IContext c) {
                this.expression = expression;
                this.time = time;
                this.exev = exev;
                this.c = c;
            }

            public double getValue() {
                if (this.evaluated) {
                    return this.value;
                }
                this.c.push();
                this.c.put((Object)IContext.Keys.TIME, this.time);
                this.valueP = this.exev.evaluate(this.expression, this.c);
                this.c.pop();
                this.value = ((INumericalValue)this.valueP.getValue()).getDouble();
                this.evaluated = true;
                return this.value;
            }
        }
    };

    public void initializeRules(Collection<Rule> rules) {
        for (Rule rule : rules) {
            this.lastEvents.put(rule.getID(), new HashMap());
        }
    }

    public void notifyExecution(int rule, int agent, double time) {
        this.lastEvents.get(rule).put(agent, time);
    }

    @Override
    public double drawActivationTime(IRate r, IContext c) {
        return this.drawActivationTimeAndProtocol(r, c).getActivationTime();
    }

    @Override
    public RateEvaluationProtocol drawActivationTimeAndProtocol(IRate r, IContext c) {
        return r.accept(this.visitor, c);
    }
}

