/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.simulator.evaluate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jamesii.ml3.model.Model;
import org.jamesii.ml3.model.agents.AgentDeclaration;
import org.jamesii.ml3.model.agents.IAgent;
import org.jamesii.ml3.model.agents.IAgentFactory;
import org.jamesii.ml3.model.agents.LinkDeclaration;
import org.jamesii.ml3.model.agents.ProcedureDefinition;
import org.jamesii.ml3.model.agents.rules.VariableBinding;
import org.jamesii.ml3.model.state.IState;
import org.jamesii.ml3.model.values.AgentValue;
import org.jamesii.ml3.model.values.BoolValue;
import org.jamesii.ml3.model.values.INumericalValue;
import org.jamesii.ml3.model.values.IValue;
import org.jamesii.ml3.model.values.SetValue;
import org.jamesii.ml3.parser.nodes.expressions.IExpression;
import org.jamesii.ml3.parser.nodes.statements.AgentCreationStatement;
import org.jamesii.ml3.parser.nodes.statements.AssignmentLeftSideNode;
import org.jamesii.ml3.parser.nodes.statements.AssignmentStatement;
import org.jamesii.ml3.parser.nodes.statements.CompositionStatement;
import org.jamesii.ml3.parser.nodes.statements.ConditionalStatement;
import org.jamesii.ml3.parser.nodes.statements.ErrorStatement;
import org.jamesii.ml3.parser.nodes.statements.ForEachStatement;
import org.jamesii.ml3.parser.nodes.statements.IStatement;
import org.jamesii.ml3.parser.nodes.statements.IStatementVisitor;
import org.jamesii.ml3.parser.nodes.statements.ProcedureCallStatement;
import org.jamesii.ml3.simulator.context.IContext;
import org.jamesii.ml3.simulator.evaluate.IExpressionEvaluator;
import org.jamesii.ml3.simulator.evaluate.IStatementEvaluator;
import org.jamesii.ml3.simulator.evaluate.StatementEvaluationProtocol;
import org.jamesii.ml3.simulator.exceptions.SimulationException;
import org.jamesii.ml3.simulator.exceptions.TypeException;

public class BasicStatementEvaluator
implements IStatementEvaluator {
    private IStatementVisitor<StatementEvaluationProtocol, IContext> visitor = new IStatementVisitor<StatementEvaluationProtocol, IContext>(){

        private StatementEvaluationProtocol assignValueToAll(AssignmentStatement s, IValue v, Collection<AssignmentLeftSideNode> leftSides, IContext c, IExpressionEvaluator exev, Model model) {
            StatementEvaluationProtocol sep = new StatementEvaluationProtocol(new StatementEvaluationProtocol[0]);
            for (AssignmentLeftSideNode alsn : leftSides) {
                IValue leftSide = exev.getValue(alsn.getBaseExpression(), c);
                IAgent agent = ((AgentValue)leftSide).getValue();
                String name = alsn.getAttributeName();
                AgentDeclaration agentType = model.getAgentDeclaration(agent.getType());
                if (agentType.getMemberType(name).equals((Object)AgentDeclaration.MemberType.ATTRIBUTE)) {
                    this.assignAttribute(s, agentType, agent, name, v);
                    sep.addChangedField(agent, name);
                    continue;
                }
                if (agentType.getMemberType(name).equals((Object)AgentDeclaration.MemberType.LINK)) {
                    return this.assignLink(agentType, agent, name, v);
                }
                throw new SimulationException(name + "is neither attribute nor link of " + agentType.getName());
            }
            return sep;
        }

        private void assignAttribute(AssignmentStatement s, AgentDeclaration agentType, IAgent agent, String name, IValue value) {
            if (!agentType.getAttribute(name).getType().isValidValue(value)) {
                throw new TypeException("Assingment type error in " + s + ".");
            }
            agent.setAttributeValue(name, value);
        }

        private StatementEvaluationProtocol assignLink(AgentDeclaration agentType, IAgent agent, String name, IValue value) {
            StatementEvaluationProtocol sep = new StatementEvaluationProtocol(new StatementEvaluationProtocol[0]);
            LinkDeclaration link = agentType.getLink(name);
            String myRole = link.getMyRole();
            Collection<IAgent> others = agent.getLinkedAgents(name);
            for (IAgent other : others) {
                other.removeLink(myRole, agent);
                sep.addChangedField(other, myRole);
            }
            Object newLinks = null;
            LinkDeclaration linkDec = agentType.getLink(name);
            newLinks = linkDec.getCardinality().getUpperBound() == 1 ? Collections.singleton(value) : ((SetValue)value).getValue();
            if (newLinks.contains(agent)) {
                throw new SimulationException("Tried do link a " + agentType.getName() + " to itself via " + name + ".");
            }
            HashSet<IAgent> newOther = new HashSet<IAgent>();
            Iterator iterator = newLinks.iterator();
            while (iterator.hasNext()) {
                IValue v = (IValue)iterator.next();
                AgentValue av = (AgentValue)v;
                IAgent a = av.getValue();
                newOther.add(a);
                a.addLink(myRole, agent);
                sep.addChangedField(a, myRole);
            }
            agent.setLink(name, newOther);
            sep.addChangedField(agent, name);
            return sep;
        }

        @Override
        public StatementEvaluationProtocol visit(AgentCreationStatement s, IContext c) {
            IAgent agent;
            IExpressionEvaluator exev = (IExpressionEvaluator)c.get((Object)IContext.Keys.EXPRESSION_EVALUATOR);
            IAgentFactory af = (IAgentFactory)c.get((Object)IContext.Keys.AGENT_FACTORY);
            IState state = (IState)c.get((Object)IContext.Keys.STATE);
            Model model = (Model)c.get((Object)IContext.Keys.MODEL);
            double time = (Double)c.get((Object)IContext.Keys.TIME);
            AgentDeclaration agentType = model.getAgentDeclaration(s.getAgentType());
            if (!s.getInitializations().containsKey("age")) {
                agent = af.createAgent(agentType, time);
            } else {
                IValue v = exev.getValue(s.getInitializations().get("age"), c);
                if (v instanceof INumericalValue) {
                    agent = af.createAgent(agentType, time - ((INumericalValue)v).getDouble());
                } else {
                    throw new SimulationException("age initialized with non-numerical value");
                }
            }
            state.addAgent(agent);
            for (Map.Entry entry : s.getInitializations().entrySet()) {
                IValue v = exev.getValue((IExpression)entry.getValue(), c);
                if (((String)entry.getKey()).equals("age")) continue;
                if (agentType.getMemberType((String)entry.getKey()) == AgentDeclaration.MemberType.ATTRIBUTE) {
                    this.assignAttribute(null, agentType, agent, (String)entry.getKey(), v);
                    continue;
                }
                if (agentType.getMemberType((String)entry.getKey()) == AgentDeclaration.MemberType.LINK) {
                    this.assignLink(agentType, agent, (String)entry.getKey(), v);
                    continue;
                }
                throw new SimulationException((String)entry.getKey() + " is neither attribute nor link of " + agentType.getName());
            }
            AgentValue newValue = new AgentValue(agent);
            for (String variable : s.getVariables()) {
                c.put(variable, newValue);
            }
            this.assignValueToAll(null, newValue, s.getLeftSides(), c, exev, model);
            StatementEvaluationProtocol statementEvaluationProtocol = new StatementEvaluationProtocol(new StatementEvaluationProtocol[0]);
            statementEvaluationProtocol.addCreatedAgent(agent);
            return statementEvaluationProtocol;
        }

        @Override
        public StatementEvaluationProtocol visit(ProcedureCallStatement s, IContext c) {
            IExpressionEvaluator exev = (IExpressionEvaluator)c.get((Object)IContext.Keys.EXPRESSION_EVALUATOR);
            IValue v = exev.getValue(s.getBaseExpression(), c);
            IAgent agent = null;
            if (!(v instanceof AgentValue)) {
                throw new SimulationException("Left side of procedure call " + s.getProcedureIdentifier() + " was no agent.");
            }
            agent = ((AgentValue)v).getValue();
            if (s.getProcedureIdentifier().equals("die")) {
                IState state = (IState)c.get((Object)IContext.Keys.STATE);
                double time = (Double)c.get((Object)IContext.Keys.TIME);
                state.killAgent(agent.getID(), time);
                StatementEvaluationProtocol result = new StatementEvaluationProtocol(new StatementEvaluationProtocol[0]);
                result.addKilledAgent(agent);
                return result;
            }
            Model m = (Model)c.get((Object)IContext.Keys.MODEL);
            AgentDeclaration agentType = m.getAgentDeclaration(agent.getType());
            ProcedureDefinition procDef = agentType.getProcedure(s.getProcedureIdentifier());
            if (procDef == null) {
                throw new SimulationException("Procedure " + s.getProcedureIdentifier() + " on " + agentType.getName() + " undefined.");
            }
            List<String> paramNames = procDef.getParameterNames();
            ArrayList<IValue> paramValues = new ArrayList<IValue>(s.getParameterExpressions().size());
            for (IExpression exp : s.getParameterExpressions()) {
                paramValues.add(exev.getValue(exp, c));
            }
            c.push();
            c.put((Object)IContext.Keys.EGO, new AgentValue(agent));
            for (int i = 0; i < paramNames.size(); ++i) {
                c.put(paramNames.get(i), paramValues.get(i));
            }
            for (VariableBinding var : procDef.getVariableBindings()) {
                c.put(var.getVariable(), var.getExpression());
            }
            StatementEvaluationProtocol result = BasicStatementEvaluator.this.evaluate(procDef.getStatement(), c);
            c.pop();
            return result;
        }

        @Override
        public StatementEvaluationProtocol visit(AssignmentStatement s, IContext c) {
            IExpressionEvaluator exev = (IExpressionEvaluator)c.get((Object)IContext.Keys.EXPRESSION_EVALUATOR);
            Model model = (Model)c.get((Object)IContext.Keys.MODEL);
            IValue newValue = exev.getValue(s.getRightSideExpression(), c);
            return this.assignValueToAll(s, newValue, s.getLeftSides(), c, exev, model);
        }

        @Override
        public StatementEvaluationProtocol visit(CompositionStatement s, IContext c) {
            StatementEvaluationProtocol lsep = BasicStatementEvaluator.this.evaluate(s.getFirst(), c);
            StatementEvaluationProtocol rsep = BasicStatementEvaluator.this.evaluate(s.getSecond(), c);
            return new StatementEvaluationProtocol(lsep, rsep);
        }

        @Override
        public StatementEvaluationProtocol visit(ConditionalStatement s, IContext c) {
            IExpressionEvaluator exev = (IExpressionEvaluator)c.get((Object)IContext.Keys.EXPRESSION_EVALUATOR);
            IValue cond = exev.getValue(s.getConditionExpression(), c);
            if (cond instanceof BoolValue) {
                BoolValue b = (BoolValue)cond;
                if (b.getValue().booleanValue()) {
                    return BasicStatementEvaluator.this.evaluate(s.getThenStatement(), c);
                }
                if (s.getElseStatement() != null) {
                    return BasicStatementEvaluator.this.evaluate(s.getElseStatement(), c);
                }
            }
            return new StatementEvaluationProtocol(new StatementEvaluationProtocol[0]);
        }

        @Override
        public StatementEvaluationProtocol visit(ForEachStatement s, IContext c) {
            IExpressionEvaluator exev = (IExpressionEvaluator)c.get((Object)IContext.Keys.EXPRESSION_EVALUATOR);
            ArrayList<StatementEvaluationProtocol> seps = new ArrayList<StatementEvaluationProtocol>();
            SetValue lv = (SetValue)exev.getValue(s.getListExpression(), c);
            Iterator iterator = lv.getValue().iterator();
            while (iterator.hasNext()) {
                IValue v = (IValue)iterator.next();
                c.put(s.getVariableName(), v);
                seps.add(BasicStatementEvaluator.this.evaluate(s.getStatement(), c));
            }
            c.remove(s.getVariableName());
            return new StatementEvaluationProtocol(seps);
        }

        @Override
        public StatementEvaluationProtocol visit(ErrorStatement s, IContext p) {
            throw new SimulationException("ErrorStatement");
        }
    };

    @Override
    public StatementEvaluationProtocol evaluate(IStatement s, IContext c) {
        return s.accept(this.visitor, c);
    }
}

