/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.simulator.evaluate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.random.RandomGenerator;
import org.jamesii.core.util.misc.Pair;
import org.jamesii.ml3.model.Model;
import org.jamesii.ml3.model.Parameters;
import org.jamesii.ml3.model.agents.AgentDeclaration;
import org.jamesii.ml3.model.agents.FunctionDefinition;
import org.jamesii.ml3.model.agents.IAgent;
import org.jamesii.ml3.model.agents.LinkDeclaration;
import org.jamesii.ml3.model.agents.rules.VariableBinding;
import org.jamesii.ml3.model.state.IState;
import org.jamesii.ml3.model.values.AgentValue;
import org.jamesii.ml3.model.values.BoolValue;
import org.jamesii.ml3.model.values.ErrorValue;
import org.jamesii.ml3.model.values.INumericalValue;
import org.jamesii.ml3.model.values.IValue;
import org.jamesii.ml3.model.values.IntValue;
import org.jamesii.ml3.model.values.NoneValue;
import org.jamesii.ml3.model.values.RealValue;
import org.jamesii.ml3.model.values.SetValue;
import org.jamesii.ml3.parser.nodes.expressions.AddExpression;
import org.jamesii.ml3.parser.nodes.expressions.AllAgentsExpression;
import org.jamesii.ml3.parser.nodes.expressions.AlterExpression;
import org.jamesii.ml3.parser.nodes.expressions.AndExpression;
import org.jamesii.ml3.parser.nodes.expressions.AttributeAccessExpression;
import org.jamesii.ml3.parser.nodes.expressions.ConditionalExpression;
import org.jamesii.ml3.parser.nodes.expressions.ConstExpression;
import org.jamesii.ml3.parser.nodes.expressions.DivideExpression;
import org.jamesii.ml3.parser.nodes.expressions.EgoExpression;
import org.jamesii.ml3.parser.nodes.expressions.EqualExpression;
import org.jamesii.ml3.parser.nodes.expressions.ErrorExpression;
import org.jamesii.ml3.parser.nodes.expressions.ExponentialExpression;
import org.jamesii.ml3.parser.nodes.expressions.FunctionCallExpression;
import org.jamesii.ml3.parser.nodes.expressions.IExpression;
import org.jamesii.ml3.parser.nodes.expressions.IExpressionVisitor;
import org.jamesii.ml3.parser.nodes.expressions.InExpression;
import org.jamesii.ml3.parser.nodes.expressions.MapConstantAccessExpression;
import org.jamesii.ml3.parser.nodes.expressions.ModuloExpression;
import org.jamesii.ml3.parser.nodes.expressions.MultiplyExpression;
import org.jamesii.ml3.parser.nodes.expressions.NowExpression;
import org.jamesii.ml3.parser.nodes.expressions.OrExpression;
import org.jamesii.ml3.parser.nodes.expressions.RelationalExpression;
import org.jamesii.ml3.parser.nodes.expressions.SetExpression;
import org.jamesii.ml3.parser.nodes.expressions.UnaryExpression;
import org.jamesii.ml3.parser.nodes.expressions.VariableAccessExpression;
import org.jamesii.ml3.simulator.context.IContext;
import org.jamesii.ml3.simulator.evaluate.ExpressionEvaluationProtocol;
import org.jamesii.ml3.simulator.evaluate.IExpressionEvaluator;
import org.jamesii.ml3.simulator.exceptions.SimulationException;
import org.jamesii.ml3.simulator.exceptions.TypeException;

public class BasicExpressionEvaluator
implements IExpressionEvaluator {
    private IExpressionVisitor<IValue, IContext> visitor = new IExpressionVisitor<IValue, IContext>(){

        private IValue callAgentFunction(IAgent agent, FunctionCallExpression e, IContext c) {
            if (e.getFunctionName().equals("isAlive")) {
                BasicExpressionEvaluator.this.eep.addAliveDependency(agent);
                return new BoolValue(agent.isAlive());
            }
            Model m = (Model)c.get((Object)IContext.Keys.MODEL);
            AgentDeclaration agentType = m.getAgentDeclaration(agent.getType());
            FunctionDefinition funDef = agentType.getFunction(e.getFunctionName());
            if (funDef == null) {
                if (e.getFunctionName().startsWith("has") && e.getFunctionName().length() >= 4) {
                    String linkName = e.getFunctionName().substring(3, e.getFunctionName().length());
                    String firstChar = String.valueOf(linkName.charAt(0));
                    LinkDeclaration linkDec = agentType.getLink(linkName = linkName.replaceFirst(firstChar, firstChar.toLowerCase()));
                    if (linkDec != null) {
                        BasicExpressionEvaluator.this.eep.addDependency(agent, linkName);
                        return new BoolValue(!agent.getLinkedAgents(linkName).isEmpty());
                    }
                    throw new SimulationException("Function " + e.getFunctionName() + " on " + agentType.getName() + " undefined.");
                }
                throw new SimulationException("Function " + e.getFunctionName() + " on " + agentType.getName() + " undefined.");
            }
            List<String> paramNames = funDef.getParameterNames();
            ArrayList<IValue> paramValues = new ArrayList<IValue>(e.getParameters().size());
            for (IExpression exp : e.getParameters()) {
                IValue v = BasicExpressionEvaluator.this.evaluateInternally(exp, c);
                paramValues.add(v);
            }
            c.push();
            c.put((Object)IContext.Keys.EGO, new AgentValue(agent));
            for (int i = 0; i < paramNames.size(); ++i) {
                c.put(paramNames.get(i), paramValues.get(i));
            }
            for (VariableBinding var : funDef.getVariableBindings()) {
                c.put(var.getVariable(), var.getExpression());
            }
            IValue result = BasicExpressionEvaluator.this.evaluateInternally(funDef.getExpression(), c);
            c.pop();
            return result;
        }

        private IValue callSetFunction(SetValue set, FunctionCallExpression e, IContext c) {
            switch (e.getFunctionName()) {
                case "size": {
                    return new IntValue(set.size());
                }
                case "isEmpty": {
                    return new BoolValue(set.getValue().isEmpty());
                }
                case "random": {
                    if (e.getParameters().isEmpty()) {
                        if (set.size() <= 0) {
                            throw new SimulationException("Set function \"random\" called on an empty set (" + e + ").");
                        }
                        RandomGenerator rng = (RandomGenerator)c.get((Object)IContext.Keys.RANDOM);
                        int index = rng.nextInt(set.size());
                        Iterator iterator = set.getValue().iterator();
                        for (int i = 0; i < index; ++i) {
                            iterator.next();
                        }
                        return (IValue)iterator.next();
                    }
                    if (e.getParameters().size() == 1) {
                        IValue nValue = BasicExpressionEvaluator.this.evaluateInternally(e.getParameters().get(0), c);
                        if (!(nValue instanceof IntValue)) {
                            throw new SimulationException("Set function \"random\" called with wrong parameters.");
                        }
                        int n = ((IntValue)nValue).getValue();
                        if (n > set.size()) {
                            n = set.size();
                        }
                        RandomGenerator rng = (RandomGenerator)c.get((Object)IContext.Keys.RANDOM);
                        HashSet results = new HashSet();
                        ArrayList setList = new ArrayList(set.getValue());
                        while (results.size() < n) {
                            results.add(setList.get(rng.nextInt(set.size())));
                        }
                        return new SetValue(results);
                    }
                    throw new SimulationException("Set function \"random\" called with wrong parameters.");
                }
                case "only": {
                    if (set.size() == 1) {
                        return (IValue)set.getValue().iterator().next();
                    }
                    throw new SimulationException("Set function \"only\" called on a set with size != 1 (" + e + ").");
                }
                case "filter": {
                    HashSet<IValue> filtered = new HashSet<IValue>();
                    Iterator n = set.getValue().iterator();
                    while (n.hasNext()) {
                        IValue v2 = (IValue)n.next();
                        c.push();
                        c.put((Object)IContext.Keys.ALTER, v2);
                        boolean pass = true;
                        for (IExpression filter : e.getParameters()) {
                            BoolValue b = (BoolValue)BasicExpressionEvaluator.this.evaluateInternally(filter, c);
                            if (b.getValue().booleanValue()) continue;
                            pass = false;
                            break;
                        }
                        c.pop();
                        if (!pass) continue;
                        filtered.add(v2);
                    }
                    return new SetValue(filtered);
                }
                case "map": {
                    HashSet<IValue> result = new HashSet<IValue>();
                    Iterator n = set.getValue().iterator();
                    while (n.hasNext()) {
                        IValue v3 = (IValue)n.next();
                        c.push();
                        c.put((Object)IContext.Keys.ALTER, v3);
                        result.add(BasicExpressionEvaluator.this.evaluateInternally(e.getParameters().get(0), c));
                        c.pop();
                    }
                    return new SetValue(result);
                }
                case "collect": {
                    HashSet result = new HashSet();
                    Iterator n = set.getValue().iterator();
                    while (n.hasNext()) {
                        IValue v4 = (IValue)n.next();
                        c.push();
                        c.put((Object)IContext.Keys.ALTER, v4);
                        result.addAll(((SetValue)BasicExpressionEvaluator.this.evaluateInternally(e.getParameters().get(0), c)).getValue());
                        c.pop();
                    }
                    return new SetValue(result);
                }
                case "sum": {
                    INumericalValue sum = new IntValue(0);
                    Iterator n = set.getValue().iterator();
                    while (n.hasNext()) {
                        IValue v5 = (IValue)n.next();
                        c.push();
                        c.put((Object)IContext.Keys.ALTER, v5);
                        sum = sum.add((INumericalValue)BasicExpressionEvaluator.this.evaluateInternally(e.getParameters().get(0), c));
                        c.pop();
                    }
                    return sum;
                }
                case "argmax": {
                    HashSet<Pair<IValue, INumericalValue>> evaledSet = new HashSet<Pair<IValue, INumericalValue>>();
                    Iterator n = set.getValue().iterator();
                    while (n.hasNext()) {
                        IValue v6 = (IValue)n.next();
                        c.push();
                        c.put((Object)IContext.Keys.ALTER, v6);
                        IValue result = BasicExpressionEvaluator.this.evaluateInternally(e.getParameters().get(0), c);
                        try {
                            evaledSet.add(new Pair<IValue, INumericalValue>(v6, (INumericalValue)result));
                        }
                        catch (ClassCastException ex) {
                            throw new SimulationException("Set function " + e.getFunctionName() + " called with nonnumerical parameters.");
                        }
                        c.pop();
                    }
                    Optional<Pair> max = evaledSet.stream().max(Comparator.comparingDouble(v -> ((INumericalValue)v.getSecondValue()).getDouble()));
                    if (max.isPresent()) {
                        return (IValue)max.get().getFirstValue();
                    }
                    throw new SimulationException("Set function " + e.getFunctionName() + " called on an empty set.");
                }
                case "argmin": {
                    HashSet<Pair<IValue, INumericalValue>> evaledSet = new HashSet<Pair<IValue, INumericalValue>>();
                    Iterator max = set.getValue().iterator();
                    while (max.hasNext()) {
                        IValue v7 = (IValue)max.next();
                        c.push();
                        c.put((Object)IContext.Keys.ALTER, v7);
                        IValue result = BasicExpressionEvaluator.this.evaluateInternally(e.getParameters().get(0), c);
                        try {
                            evaledSet.add(new Pair<IValue, INumericalValue>(v7, (INumericalValue)result));
                        }
                        catch (ClassCastException ex) {
                            throw new SimulationException("Set function " + e.getFunctionName() + " called with nonnumerical parameters.");
                        }
                        c.pop();
                    }
                    Optional<Pair> min = evaledSet.stream().min(Comparator.comparingDouble(v -> ((INumericalValue)v.getSecondValue()).getDouble()));
                    if (min.isPresent()) {
                        return (IValue)min.get().getFirstValue();
                    }
                    throw new SimulationException("Set function " + e.getFunctionName() + " called on an empty set.");
                }
            }
            throw new SimulationException("Set function " + e.getFunctionName() + " not implemented (" + e + ").");
        }

        private IValue callMathFunction(FunctionCallExpression e, IContext c) {
            if (e.getFunctionName().equals("abs")) {
                IValue v = BasicExpressionEvaluator.this.evaluateInternally(e.getParameters().get(0), c);
                if (v instanceof RealValue) {
                    return new RealValue(Math.abs(((RealValue)v).getValue()));
                }
                if (v instanceof IntValue) {
                    return new IntValue(Math.abs(((IntValue)v).getValue()));
                }
                throw new TypeException("Type error in arguments of " + e.getFunctionName() + ".");
            }
            if (e.getFunctionName().equals("random")) {
                RandomGenerator rng = (RandomGenerator)c.get((Object)IContext.Keys.RANDOM);
                return new RealValue(rng.nextDouble());
            }
            if (e.getFunctionName().equals("ceil")) {
                IValue v = BasicExpressionEvaluator.this.evaluateInternally(e.getParameters().get(0), c);
                if (v instanceof RealValue) {
                    return new IntValue((int)Math.ceil(((RealValue)v).getValue()));
                }
                if (v instanceof IntValue) {
                    return new IntValue((int)Math.ceil(((IntValue)v).getValue().intValue()));
                }
                throw new TypeException("Type error in arguments of " + e.getFunctionName() + ".");
            }
            if (e.getFunctionName().equals("floor")) {
                IValue v = BasicExpressionEvaluator.this.evaluateInternally(e.getParameters().get(0), c);
                if (v instanceof RealValue) {
                    return new IntValue((int)Math.floor(((RealValue)v).getValue()));
                }
                if (v instanceof IntValue) {
                    return new IntValue((int)Math.floor(((IntValue)v).getValue().intValue()));
                }
                throw new TypeException("Type error in arguments of " + e.getFunctionName() + ".");
            }
            if (e.getFunctionName().equals("round")) {
                IValue v = BasicExpressionEvaluator.this.evaluateInternally(e.getParameters().get(0), c);
                if (v instanceof RealValue) {
                    return new IntValue((int)Math.round(((RealValue)v).getValue()));
                }
                if (v instanceof IntValue) {
                    return new IntValue(Math.round(((IntValue)v).getValue().intValue()));
                }
                throw new TypeException("Type error in arguments of " + e.getFunctionName() + ".");
            }
            if (e.getFunctionName().equals("sqrt")) {
                IValue v = BasicExpressionEvaluator.this.evaluateInternally(e.getParameters().get(0), c);
                if (v instanceof RealValue) {
                    return new RealValue(Math.sqrt(((RealValue)v).getValue()));
                }
                if (v instanceof IntValue) {
                    return new RealValue(Math.sqrt(((IntValue)v).getValue().intValue()));
                }
                throw new TypeException("Type error in arguments of " + e.getFunctionName() + ".");
            }
            if (e.getFunctionName().equals("cos")) {
                IValue v = BasicExpressionEvaluator.this.evaluateInternally(e.getParameters().get(0), c);
                if (v instanceof RealValue) {
                    return new RealValue(Math.cos(((RealValue)v).getValue()));
                }
                if (v instanceof IntValue) {
                    return new RealValue(Math.cos(((IntValue)v).getValue().intValue()));
                }
                throw new TypeException("Type error in arguments of " + e.getFunctionName() + ".");
            }
            if (e.getFunctionName().equals("sin")) {
                IValue v = BasicExpressionEvaluator.this.evaluateInternally(e.getParameters().get(0), c);
                if (v instanceof RealValue) {
                    return new RealValue(Math.sin(((RealValue)v).getValue()));
                }
                if (v instanceof IntValue) {
                    return new RealValue(Math.sin(((IntValue)v).getValue().intValue()));
                }
                throw new TypeException("Type error in arguments of " + e.getFunctionName() + ".");
            }
            if (e.getFunctionName().equals("tan")) {
                IValue v = BasicExpressionEvaluator.this.evaluateInternally(e.getParameters().get(0), c);
                if (v instanceof RealValue) {
                    return new RealValue(Math.tan(((RealValue)v).getValue()));
                }
                if (v instanceof IntValue) {
                    return new RealValue(Math.tan(((IntValue)v).getValue().intValue()));
                }
                throw new TypeException("Type error in arguments of " + e.getFunctionName() + ".");
            }
            if (e.getFunctionName().equals("exp")) {
                IValue v = BasicExpressionEvaluator.this.evaluateInternally(e.getParameters().get(0), c);
                if (v instanceof RealValue) {
                    return new RealValue(Math.exp(((RealValue)v).getValue()));
                }
                if (v instanceof IntValue) {
                    return new RealValue(Math.exp(((IntValue)v).getValue().intValue()));
                }
                throw new TypeException("Type error in arguments of " + e.getFunctionName() + ".");
            }
            if (e.getFunctionName().equals("log")) {
                IValue v = BasicExpressionEvaluator.this.evaluateInternally(e.getParameters().get(0), c);
                if (v instanceof RealValue) {
                    return new RealValue(Math.log(((RealValue)v).getValue()));
                }
                if (v instanceof IntValue) {
                    return new RealValue(Math.log(((IntValue)v).getValue().intValue()));
                }
                throw new TypeException("Type error in arguments of " + e.getFunctionName() + ".");
            }
            if (e.getFunctionName().equals("log10")) {
                IValue v = BasicExpressionEvaluator.this.evaluateInternally(e.getParameters().get(0), c);
                if (v instanceof RealValue) {
                    return new RealValue(Math.log10(((RealValue)v).getValue()));
                }
                if (v instanceof IntValue) {
                    return new RealValue(Math.log10(((IntValue)v).getValue().intValue()));
                }
                throw new TypeException("Type error in arguments of " + e.getFunctionName() + ".");
            }
            if (e.getFunctionName().equals("signum")) {
                IValue v = BasicExpressionEvaluator.this.evaluateInternally(e.getParameters().get(0), c);
                if (v instanceof RealValue) {
                    return new IntValue((int)Math.signum(((RealValue)v).getValue()));
                }
                if (v instanceof IntValue) {
                    return new IntValue((int)Math.signum(((IntValue)v).getValue().intValue()));
                }
                throw new TypeException("Type error in arguments of " + e.getFunctionName() + ".");
            }
            if (e.getFunctionName().equals("min")) {
                IValue v1 = BasicExpressionEvaluator.this.evaluateInternally(e.getParameters().get(0), c);
                IValue v2 = BasicExpressionEvaluator.this.evaluateInternally(e.getParameters().get(1), c);
                if (v1 instanceof INumericalValue && v2 instanceof INumericalValue) {
                    if (((INumericalValue)v1).compareTo((INumericalValue)v2) <= 0) {
                        return v1;
                    }
                    return v2;
                }
                throw new TypeException("Type error in arguments of " + e.getFunctionName() + ".");
            }
            if (e.getFunctionName().equals("max")) {
                IValue v1 = BasicExpressionEvaluator.this.evaluateInternally(e.getParameters().get(0), c);
                IValue v2 = BasicExpressionEvaluator.this.evaluateInternally(e.getParameters().get(1), c);
                if (v1 instanceof INumericalValue && v2 instanceof INumericalValue) {
                    if (((INumericalValue)v1).compareTo((INumericalValue)v2) >= 0) {
                        return v1;
                    }
                    return v2;
                }
                throw new TypeException("Type error in arguments of " + e.getFunctionName() + ".");
            }
            if (e.getFunctionName().equals("normal")) {
                RandomGenerator rng = (RandomGenerator)c.get((Object)IContext.Keys.RANDOM);
                IValue meanProtocol = BasicExpressionEvaluator.this.evaluateInternally(e.getParameters().get(0), c);
                IValue deviationProtocol = BasicExpressionEvaluator.this.evaluateInternally(e.getParameters().get(1), c);
                double mean = ((INumericalValue)meanProtocol).getDouble();
                double deviation = ((INumericalValue)deviationProtocol).getDouble();
                NormalDistribution norm = new NormalDistribution(rng, mean, deviation);
                return new RealValue(norm.sample());
            }
            throw new SimulationException("Math function " + e.getFunctionName() + " not implemented.");
        }

        @Override
        public IValue visit(AddExpression e, IContext c) {
            IValue ret;
            IValue left = BasicExpressionEvaluator.this.evaluateInternally(e.getLeftSummand(), c);
            IValue right = BasicExpressionEvaluator.this.evaluateInternally(e.getRightSummand(), c);
            if (!(left instanceof SetValue) && !(right instanceof SetValue)) {
                try {
                    INumericalValue nleft = (INumericalValue)left;
                    INumericalValue nright = (INumericalValue)right;
                    switch (e.getOperator()) {
                        case ADD: {
                            ret = nleft.add(nright);
                            break;
                        }
                        case SUB: {
                            ret = nleft.subtract(nright);
                            break;
                        }
                        default: {
                            throw new SimulationException("Impossible.");
                        }
                    }
                }
                catch (ClassCastException e1) {
                    throw new TypeException("Type of add operand not Real or Nat or Set.");
                }
            } else {
                switch (e.getOperator()) {
                    case ADD: {
                        if (left instanceof SetValue) {
                            if (right instanceof SetValue) {
                                SetValue leftList = (SetValue)left;
                                SetValue rightList = (SetValue)right;
                                ArrayList result = new ArrayList();
                                result.addAll(leftList.getValue());
                                result.addAll(rightList.getValue());
                                ret = new SetValue(result);
                                break;
                            }
                            SetValue leftList = (SetValue)left;
                            ArrayList<IValue> result = new ArrayList<IValue>();
                            result.addAll((Collection<IValue>)leftList.getValue());
                            result.add(right);
                            ret = new SetValue(result);
                            break;
                        }
                        SetValue rightList = (SetValue)right;
                        ArrayList<IValue> result = new ArrayList<IValue>();
                        result.add(left);
                        result.addAll((Collection<IValue>)rightList.getValue());
                        ret = new SetValue(result);
                        break;
                    }
                    case SUB: {
                        if (left instanceof SetValue) {
                            if (right instanceof SetValue) {
                                SetValue leftList = (SetValue)left;
                                SetValue rightList = (SetValue)right;
                                ArrayList result = new ArrayList();
                                result.addAll(leftList.getValue());
                                result.removeAll((Collection<?>)rightList.getValue());
                                ret = new SetValue(result);
                                break;
                            }
                            SetValue leftList = (SetValue)left;
                            ArrayList<IValue> result = new ArrayList<IValue>();
                            result.addAll((Collection<IValue>)leftList.getValue());
                            result.removeIf(right::equals);
                            ret = new SetValue(result);
                            break;
                        }
                        throw new TypeException("Left side of set-'-' is not a set.");
                    }
                    default: {
                        throw new SimulationException("Impossible.");
                    }
                }
            }
            return ret;
        }

        @Override
        public IValue visit(AllAgentsExpression e, IContext c) {
            IState state = (IState)c.get((Object)IContext.Keys.STATE);
            ArrayList<AgentValue> avs = new ArrayList<AgentValue>();
            for (IAgent agent : state.getAgentsAliveByType(e.getAgentType())) {
                avs.add(new AgentValue(agent));
            }
            BasicExpressionEvaluator.this.eep.addAgentTypeDependency(e.getAgentType());
            return new SetValue(avs);
        }

        @Override
        public IValue visit(AlterExpression e, IContext c) {
            IValue a = (IValue)c.get((Object)IContext.Keys.ALTER);
            if (a == null) {
                throw new SimulationException("Alter is null.");
            }
            return a;
        }

        @Override
        public IValue visit(AndExpression e, IContext c) {
            IValue left = BasicExpressionEvaluator.this.evaluateInternally(e.getLeftExpression(), c);
            if (left instanceof BoolValue) {
                if (((BoolValue)left).getValue().booleanValue()) {
                    IValue right = BasicExpressionEvaluator.this.evaluateInternally(e.getRightExpression(), c);
                    if (right instanceof BoolValue) {
                        return right;
                    }
                    throw new TypeException("Type of and operand not Bool.");
                }
                return left;
            }
            throw new TypeException("Type of and operand not Bool.");
        }

        @Override
        public IValue visit(AttributeAccessExpression e, IContext c) {
            double now = (Double)c.get((Object)IContext.Keys.TIME);
            Model m = (Model)c.get((Object)IContext.Keys.MODEL);
            IValue left = BasicExpressionEvaluator.this.evaluateInternally(e.getBaseExpression(), c);
            String name = e.getAttributeName();
            IAgent agent = ((AgentValue)left).getValue();
            AgentDeclaration agentType = m.getAgentDeclaration(agent.getType());
            AgentDeclaration.MemberType memberType = agentType.getMemberType(name);
            if (memberType == null) {
                throw new SimulationException("Expected an agent of type " + agent.getType() + " to have an attribute or link named \"" + name + "\", but he had none.");
            }
            if (memberType == AgentDeclaration.MemberType.AGE) {
                return new RealValue(agent.getAge(now));
            }
            if (memberType == AgentDeclaration.MemberType.ATTRIBUTE) {
                BasicExpressionEvaluator.this.eep.addDependency(agent, name);
                return agent.getAttributeValue(name);
            }
            if (memberType == AgentDeclaration.MemberType.LINK) {
                Collection<IAgent> linked = agent.getLinkedAgents(name);
                LinkDeclaration linkDec = agentType.getLink(name);
                if (linkDec.getCardinality().getUpperBound() == 1) {
                    try {
                        BasicExpressionEvaluator.this.eep.addDependency(agent, name);
                        return new AgentValue(linked.iterator().next());
                    }
                    catch (NoSuchElementException ex) {
                        throw new SimulationException("No value for link " + name + " set.");
                    }
                }
                ArrayList<AgentValue> ret = new ArrayList<AgentValue>(linked.size());
                for (IAgent a : linked) {
                    ret.add(new AgentValue(a));
                }
                BasicExpressionEvaluator.this.eep.addDependency(agent, name);
                return new SetValue(ret);
            }
            throw new SimulationException(name + " is neither attribute nor link of " + agentType.getName());
        }

        @Override
        public IValue visit(ConditionalExpression e, IContext c) {
            IValue condition = BasicExpressionEvaluator.this.evaluateInternally(e.getCondition(), c);
            if (condition instanceof BoolValue) {
                if (((BoolValue)condition).getValue().booleanValue()) {
                    return BasicExpressionEvaluator.this.evaluateInternally(e.getThenExpression(), c);
                }
                return BasicExpressionEvaluator.this.evaluateInternally(e.getElseExpression(), c);
            }
            throw new TypeException("Type of ternary epression condition not Bool.");
        }

        @Override
        public IValue visit(ConstExpression e, IContext c) {
            return e.getValue();
        }

        @Override
        public IValue visit(DivideExpression e, IContext c) {
            IValue left = BasicExpressionEvaluator.this.evaluateInternally(e.getDividend(), c);
            IValue right = BasicExpressionEvaluator.this.evaluateInternally(e.getDivisor(), c);
            try {
                INumericalValue nleft = (INumericalValue)left;
                INumericalValue nright = (INumericalValue)right;
                if (nright.getDouble() == 0.0) {
                    throw new SimulationException("Division by zero in " + e);
                }
                return nleft.divide(nright);
            }
            catch (ClassCastException e1) {
                throw new TypeException("Type of divide operand not Real or Nat.");
            }
        }

        @Override
        public IValue visit(EgoExpression e, IContext c) {
            IValue a = (IValue)c.get((Object)IContext.Keys.EGO);
            if (a == null) {
                throw new SimulationException("Ego is null.");
            }
            return a;
        }

        @Override
        public IValue visit(EqualExpression e, IContext c) {
            IValue left = BasicExpressionEvaluator.this.evaluateInternally(e.getLeftExpression(), c);
            IValue right = BasicExpressionEvaluator.this.evaluateInternally(e.getRightExpression(), c);
            if (e.isUnequals()) {
                return new BoolValue(!left.equals(right));
            }
            return new BoolValue(left.equals(right));
        }

        @Override
        public IValue visit(FunctionCallExpression e, IContext c) {
            if (e.getBaseExpression() == null) {
                return this.callMathFunction(e, c);
            }
            IValue left = BasicExpressionEvaluator.this.evaluateInternally(e.getBaseExpression(), c);
            if (left instanceof AgentValue) {
                IAgent agent = ((AgentValue)left).getValue();
                return this.callAgentFunction(agent, e, c);
            }
            if (left instanceof SetValue) {
                return this.callSetFunction((SetValue)left, e, c);
            }
            throw new SimulationException("Invalid function call.");
        }

        @Override
        public IValue visit(InExpression e, IContext c) {
            IValue v = BasicExpressionEvaluator.this.evaluateInternally(e.getElement(), c);
            SetValue list = (SetValue)BasicExpressionEvaluator.this.evaluateInternally(e.getList(), c);
            Iterator iterator = list.getValue().iterator();
            while (iterator.hasNext()) {
                IValue v1 = (IValue)iterator.next();
                if (!v.equals(v1)) continue;
                return BoolValue.TRUE;
            }
            return BoolValue.FALSE;
        }

        @Override
        public IValue visit(SetExpression e, IContext c) {
            ArrayList<IValue> values = new ArrayList<IValue>(e.getExpressions().size());
            for (IExpression exp : e.getExpressions()) {
                values.add(BasicExpressionEvaluator.this.evaluateInternally(exp, c));
            }
            return new SetValue(values);
        }

        @Override
        public IValue visit(MapConstantAccessExpression e, IContext c) {
            Parameters params = (Parameters)c.get((Object)IContext.Keys.PARAMETERS);
            IValue in = BasicExpressionEvaluator.this.evaluateInternally(e.getParameter(), c);
            return params.getValueMap(e.getMapName()).get(in);
        }

        @Override
        public IValue visit(ModuloExpression e, IContext c) {
            IValue left = BasicExpressionEvaluator.this.evaluateInternally(e.getDividend(), c);
            IValue right = BasicExpressionEvaluator.this.evaluateInternally(e.getDivisor(), c);
            try {
                INumericalValue nleft = (INumericalValue)left;
                INumericalValue nright = (INumericalValue)right;
                return nleft.modulo(nright);
            }
            catch (ClassCastException e1) {
                throw new TypeException("Type of modulo operand not Real or Nat.");
            }
        }

        @Override
        public IValue visit(MultiplyExpression e, IContext c) {
            IValue left = BasicExpressionEvaluator.this.evaluateInternally(e.getLeftFactor(), c);
            IValue right = BasicExpressionEvaluator.this.evaluateInternally(e.getRightFactor(), c);
            try {
                INumericalValue nleft = (INumericalValue)left;
                INumericalValue nright = (INumericalValue)right;
                return nleft.multiply(nright);
            }
            catch (ClassCastException e1) {
                throw new TypeException("Type of multiply operand not Real or Nat.");
            }
        }

        @Override
        public IValue visit(NowExpression e, IContext c) {
            return new RealValue((Double)c.get((Object)IContext.Keys.TIME));
        }

        @Override
        public IValue visit(OrExpression e, IContext c) {
            IValue left = BasicExpressionEvaluator.this.evaluateInternally(e.getLeftExpression(), c);
            if (left instanceof BoolValue) {
                if (((BoolValue)left).getValue().booleanValue()) {
                    return left;
                }
                IValue right = BasicExpressionEvaluator.this.evaluateInternally(e.getRightExpression(), c);
                if (right instanceof BoolValue) {
                    return right;
                }
                throw new TypeException("Type of or operand not Bool.");
            }
            throw new TypeException("Type of or operand not Bool.");
        }

        @Override
        public IValue visit(RelationalExpression e, IContext c) {
            IValue left = BasicExpressionEvaluator.this.evaluateInternally(e.getLeftExpression(), c);
            IValue right = BasicExpressionEvaluator.this.evaluateInternally(e.getRightExpression(), c);
            try {
                BoolValue result;
                INumericalValue nleft = (INumericalValue)left;
                INumericalValue nright = (INumericalValue)right;
                switch (e.getOperator()) {
                    case G: {
                        result = new BoolValue(nleft.compareTo(nright) > 0);
                        break;
                    }
                    case GEQ: {
                        result = new BoolValue(nleft.compareTo(nright) >= 0);
                        break;
                    }
                    case L: {
                        result = new BoolValue(nleft.compareTo(nright) < 0);
                        break;
                    }
                    case LEQ: {
                        result = new BoolValue(nleft.compareTo(nright) <= 0);
                        break;
                    }
                    default: {
                        throw new SimulationException("Impossible.");
                    }
                }
                return result;
            }
            catch (ClassCastException e1) {
                throw new TypeException("RelationalExpression with nonnumerical arguments.");
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public IValue visit(UnaryExpression e, IContext c) {
            void var4_7;
            IValue v = BasicExpressionEvaluator.this.evaluateInternally(e.getExpression(), c);
            if (e.getOperator().equals((Object)UnaryExpression.UnaryOperator.MINUS)) {
                if (v instanceof IntValue) {
                    IntValue intValue = new IntValue(-((IntValue)v).getValue().intValue());
                    return var4_7;
                } else {
                    if (!(v instanceof RealValue)) throw new TypeException("Type of not operand not Real or Nat.");
                    RealValue realValue = new RealValue(-((RealValue)v).getValue().doubleValue());
                }
                return var4_7;
            } else {
                if (!e.getOperator().equals((Object)UnaryExpression.UnaryOperator.NOT)) throw new SimulationException("Unknown unary operator.");
                if (!(v instanceof BoolValue)) throw new TypeException("Type of not operand not Bool.");
                BoolValue boolValue = new BoolValue(((BoolValue)v).getValue() == false);
            }
            return var4_7;
        }

        @Override
        public IValue visit(VariableAccessExpression e, IContext c) {
            Parameters params = (Parameters)c.get((Object)IContext.Keys.PARAMETERS);
            if (e.getVariableName().startsWith("?")) {
                Object o = c.get(e.getVariableName());
                if (o instanceof IValue) {
                    return (IValue)o;
                }
                if (o instanceof IExpression) {
                    IExpression exp = (IExpression)o;
                    IValue result = BasicExpressionEvaluator.this.evaluateInternally(exp, c);
                    c.put(e.getVariableName(), result);
                    return result;
                }
                throw new SimulationException("Object (" + o + ") for " + e.getVariableName() + " was neither Expression nor Value.");
            }
            if (params.isConstant(e.getVariableName())) {
                return params.getValue(e.getVariableName());
            }
            throw new SimulationException("Unknown constant " + e.getVariableName() + ".");
        }

        @Override
        public IValue visit(ExponentialExpression e, IContext c) {
            IValue base = BasicExpressionEvaluator.this.evaluateInternally(e.getBase(), c);
            IValue exponent = BasicExpressionEvaluator.this.evaluateInternally(e.getExponent(), c);
            try {
                INumericalValue nbase = (INumericalValue)base;
                INumericalValue nexponent = (INumericalValue)exponent;
                return nbase.pow(nexponent);
            }
            catch (ClassCastException e1) {
                throw new TypeException("Type of multiply operand not Real or Nat.");
            }
        }

        @Override
        public IValue visit(ErrorExpression e, IContext p) {
            return ErrorValue.get();
        }
    };
    private ExpressionEvaluationProtocol eep;

    private IValue evaluateInternally(IExpression e, IContext c) {
        return e.accept(this.visitor, c);
    }

    @Override
    public IValue getValue(IExpression e, IContext c) {
        return this.evaluate(e, c).getValue();
    }

    @Override
    public ExpressionEvaluationProtocol evaluate(IExpression e, IContext c) {
        this.eep = new ExpressionEvaluationProtocol((IValue)new NoneValue(), new ExpressionEvaluationProtocol[0]);
        this.eep.setValue(this.evaluateInternally(e, c));
        return this.eep;
    }
}

