/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.parser.nodes.statements;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jamesii.ml3.parser.AbstractParseTreeNode;
import org.jamesii.ml3.parser.IParseTreeNode;
import org.jamesii.ml3.parser.nodes.expressions.IExpression;
import org.jamesii.ml3.parser.nodes.statements.IStatement;
import org.jamesii.ml3.parser.nodes.statements.IStatementVisitor;

public class ProcedureCallStatement
extends AbstractParseTreeNode
implements IStatement {
    private IExpression baseExpression;
    private String procedureIdentifier;
    private List<IExpression> parameterExpressions;

    public ProcedureCallStatement(IParseTreeNode parent, String procedureIdentifier) {
        super(parent);
        this.procedureIdentifier = procedureIdentifier;
        this.setParameterExpressions(new ArrayList<IExpression>());
    }

    public String toString() {
        String params = String.join((CharSequence)", ", this.getParameterExpressions().stream().map(e -> e.toString()).collect(Collectors.toList()));
        return (this.baseExpression != null ? this.baseExpression + "." : "") + this.procedureIdentifier + "(" + params + ")";
    }

    @Override
    public <R, P> R accept(IStatementVisitor<R, P> v, P p) {
        return v.visit(this, p);
    }

    public IExpression getBaseExpression() {
        return this.baseExpression;
    }

    public void setBaseExpression(IExpression baseExpression) {
        this.baseExpression = baseExpression;
    }

    public String getProcedureIdentifier() {
        return this.procedureIdentifier;
    }

    public void setProcedureIdentifier(String procedureIdentifier) {
        this.procedureIdentifier = procedureIdentifier;
    }

    public List<IExpression> getParameterExpressions() {
        return this.parameterExpressions;
    }

    public void setParameterExpressions(List<IExpression> parameterExpressions) {
        this.parameterExpressions = parameterExpressions;
    }
}

