/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.parser.nodes;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jamesii.ml3.parser.AbstractParseTreeNode;
import org.jamesii.ml3.parser.nodes.ModelNode;
import org.jamesii.ml3.parser.nodes.ParameterDeclarationNode;
import org.jamesii.ml3.parser.nodes.WhereClauseNode;
import org.jamesii.ml3.parser.nodes.expressions.IExpression;

public class FunctionDeclarationNode
extends AbstractParseTreeNode {
    private String agentType;
    private String functionName;
    private List<ParameterDeclarationNode> parameters;
    private IExpression expression;
    private WhereClauseNode whereClause;

    public FunctionDeclarationNode(ModelNode modelNode, String agentType, String functionName) {
        super(modelNode);
        this.agentType = agentType;
        this.functionName = functionName;
        this.parameters = new ArrayList<ParameterDeclarationNode>();
    }

    public String toString() {
        String params = String.join((CharSequence)", ", this.parameters.stream().map(e -> e.toString()).collect(Collectors.toList()));
        String where = this.whereClause != null ? "\n" + this.whereClause : "";
        return this.agentType + "." + this.functionName + "(" + params + ") := " + this.expression + where + ";\n\n";
    }

    public String getAgentType() {
        return this.agentType;
    }

    public void setAgentType(String agentType) {
        this.agentType = agentType;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public IExpression getExpression() {
        return this.expression;
    }

    public void setExpression(IExpression expression) {
        this.expression = expression;
    }

    public WhereClauseNode getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(WhereClauseNode whereClause) {
        this.whereClause = whereClause;
    }

    public List<ParameterDeclarationNode> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<ParameterDeclarationNode> parameters) {
        this.parameters = parameters;
    }

    public void addParameter(ParameterDeclarationNode parameter) {
        this.parameters.add(parameter);
    }
}

