/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.parser;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.Collection;
import java.util.List;
import org.antlr.v4.runtime.Token;
import org.jamesii.ml3.model.values.IValue;
import org.jamesii.ml3.parser.ILanguageErrorListener;
import org.jamesii.ml3.parser.ML3Parser;
import org.jamesii.ml3.parser.PrintoutLanguageErrorListener;
import org.jamesii.ml3.parser.nodes.ModelNode;
import org.jamesii.ml3.parser.nodes.expressions.ErrorExpression;
import org.jamesii.ml3.parser.nodes.expressions.IExpression;
import org.jamesii.ml3.parser.nodes.statements.ErrorStatement;
import org.jamesii.ml3.parser.nodes.statements.IStatement;

public class ParserUtil {
    public static ModelNode parseFile(String filePath, ILanguageErrorListener ... listeners) throws IOException {
        File file = new File(filePath);
        String code = new String(Files.readAllBytes(file.toPath()), Charset.forName("utf-8"));
        ML3Parser parser = new ML3Parser();
        for (ILanguageErrorListener listener : listeners) {
            parser.addListener(listener);
        }
        ModelNode parsedModel = parser.parseFromString(code);
        return parsedModel;
    }

    public static ModelNode parseFile(String filePath, Collection<ILanguageErrorListener> listeners) throws IOException {
        File file = new File(filePath);
        String code = new String(Files.readAllBytes(file.toPath()), Charset.forName("utf-8"));
        ML3Parser parser = new ML3Parser();
        for (ILanguageErrorListener listener : listeners) {
            parser.addListener(listener);
        }
        ModelNode parsedModel = parser.parseFromString(code);
        return parsedModel;
    }

    public static ModelNode parseCode(String code, ILanguageErrorListener ... listeners) throws IOException {
        ML3Parser parser = new ML3Parser();
        for (ILanguageErrorListener listener : listeners) {
            parser.addListener(listener);
        }
        ModelNode parsedModel = parser.parseFromString(code);
        return parsedModel;
    }

    public static ModelNode parseCode(String code, Collection<ILanguageErrorListener> listeners) throws IOException {
        ML3Parser parser = new ML3Parser();
        for (ILanguageErrorListener listener : listeners) {
            parser.addListener(listener);
        }
        ModelNode parsedModel = parser.parseFromString(code);
        return parsedModel;
    }

    public static ModelNode parseFile(String filePath, PrintStream out) throws IOException {
        File file = new File(filePath);
        String code = new String(Files.readAllBytes(file.toPath()), Charset.forName("utf-8"));
        ML3Parser parser = new ML3Parser();
        parser.addListener(new PrintoutLanguageErrorListener(out));
        ModelNode parsedModel = parser.parseFromString(code);
        return parsedModel;
    }

    public static ModelNode parseCode(String code, PrintStream out) {
        ML3Parser parser = new ML3Parser();
        parser.addListener(new PrintoutLanguageErrorListener(out));
        ModelNode parsedModel = parser.parseFromString(code);
        return parsedModel;
    }

    public static ModelNode parseFile(String filePath) throws IOException {
        File file = new File(filePath);
        String code = new String(Files.readAllBytes(file.toPath()), Charset.forName("utf-8"));
        ML3Parser parser = new ML3Parser();
        ModelNode parsedModel = parser.parseFromString(code);
        return parsedModel;
    }

    public static ModelNode parseCode(String code) {
        ML3Parser parser = new ML3Parser();
        ModelNode parsedModel = parser.parseFromString(code);
        return parsedModel;
    }

    public static List<Token> lexFile(String filePath) throws IOException {
        File file = new File(filePath);
        String code = new String(Files.readAllBytes(file.toPath()), Charset.forName("utf-8"));
        ML3Parser parser = new ML3Parser();
        return parser.getTokenList(code);
    }

    public static List<Token> lexCode(String code) {
        ML3Parser parser = new ML3Parser();
        return parser.getTokenList(code);
    }

    public static IExpression parseExpressionCode(String expressionString) {
        ML3Parser parser = new ML3Parser();
        return parser.parseExpressionFromString(expressionString);
    }

    public static IStatement parseStatementCode(String statementString) {
        ML3Parser parser = new ML3Parser();
        return parser.parseStatementFromString(statementString);
    }

    public static IExpression parseExpressionFile(String path) {
        String code;
        File file = new File(path);
        try {
            code = new String(Files.readAllBytes(file.toPath()), Charset.forName("utf-8"));
        }
        catch (IOException e) {
            return new ErrorExpression(null);
        }
        ML3Parser parser = new ML3Parser();
        return parser.parseExpressionFromString(code);
    }

    public static IStatement parseStatementFile(String path) {
        String code;
        File file = new File(path);
        try {
            code = new String(Files.readAllBytes(file.toPath()), Charset.forName("utf-8"));
        }
        catch (IOException e) {
            return new ErrorStatement(null);
        }
        ML3Parser parser = new ML3Parser();
        return parser.parseStatementFromString(code);
    }

    public static IValue parseConstantCode(String constantString) {
        ML3Parser parser = new ML3Parser();
        return parser.parseConstantFromString(constantString);
    }
}

