/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.parser;

import java.util.Collection;
import java.util.List;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.IntStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.jamesii.ml3.model.values.ErrorValue;
import org.jamesii.ml3.model.values.IValue;
import org.jamesii.ml3.parser.AbstractLanguageErrorListenable;
import org.jamesii.ml3.parser.ILanguageErrorListener;
import org.jamesii.ml3.parser.ParserANTLRErrorListener;
import org.jamesii.ml3.parser.ParserANTLRVisitor;
import org.jamesii.ml3.parser.antlr4.ML3Lexer;
import org.jamesii.ml3.parser.antlr4.ML3Parser;
import org.jamesii.ml3.parser.nodes.ModelNode;
import org.jamesii.ml3.parser.nodes.expressions.ErrorExpression;
import org.jamesii.ml3.parser.nodes.expressions.IExpression;
import org.jamesii.ml3.parser.nodes.statements.ErrorStatement;
import org.jamesii.ml3.parser.nodes.statements.IStatement;

public class ML3Parser
extends AbstractLanguageErrorListenable {
    private ParserANTLRVisitor antlrVisitor;
    private ParserANTLRErrorListener antlrErrorListener;
    private ModelNode modelNode;
    private org.jamesii.ml3.parser.antlr4.ML3Parser parser;
    private ML3Lexer lexer = new ML3Lexer(null);

    public ML3Parser() {
        this.parser = new org.jamesii.ml3.parser.antlr4.ML3Parser(null);
        this.antlrVisitor = new ParserANTLRVisitor();
        this.antlrErrorListener = new ParserANTLRErrorListener();
        this.lexer.removeErrorListeners();
        this.lexer.addErrorListener(this.antlrErrorListener);
        this.parser.removeErrorListeners();
        this.parser.addErrorListener(this.antlrErrorListener);
    }

    private void resetParser() {
        this.modelNode = null;
        this.antlrVisitor.getParseStack().clear();
    }

    public ModelNode parseFromString(String code) {
        this.resetParser();
        this.lexer.setInputStream((IntStream)new ANTLRInputStream(code));
        this.lexer.reset();
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)this.lexer);
        this.parser.setTokenStream((TokenStream)tokenStream);
        ML3Parser.ModelContext modelCtx = this.parser.model();
        try {
            this.modelNode = this.antlrVisitor.visitModel(modelCtx);
        }
        catch (Exception e) {
            return new ModelNode();
        }
        return this.modelNode;
    }

    public IExpression parseExpressionFromString(String code) {
        this.resetParser();
        this.antlrVisitor.getParseStack().push(null);
        this.lexer.setInputStream((IntStream)new ANTLRInputStream(code));
        this.lexer.reset();
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)this.lexer);
        this.parser.setTokenStream((TokenStream)tokenStream);
        ML3Parser.ExpressionContext expressionCtx = this.parser.expression();
        try {
            return this.antlrVisitor.visitExpression(expressionCtx);
        }
        catch (Exception e) {
            return new ErrorExpression(null);
        }
    }

    public IStatement parseStatementFromString(String code) {
        this.resetParser();
        this.antlrVisitor.getParseStack().push(null);
        this.lexer.setInputStream((IntStream)new ANTLRInputStream(code));
        this.lexer.reset();
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)this.lexer);
        this.parser.setTokenStream((TokenStream)tokenStream);
        ML3Parser.StatementContext statementCtx = this.parser.statement();
        try {
            return this.antlrVisitor.visitStatement(statementCtx);
        }
        catch (Exception e) {
            return new ErrorStatement(null);
        }
    }

    public IValue parseConstantFromString(String code) {
        this.resetParser();
        this.antlrVisitor.getParseStack().push(null);
        this.lexer.setInputStream((IntStream)new ANTLRInputStream(code));
        this.lexer.reset();
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)this.lexer);
        this.parser.setTokenStream((TokenStream)tokenStream);
        ML3Parser.ConstantContext constantCtx = this.parser.constant();
        try {
            return this.antlrVisitor.visitConstant(constantCtx);
        }
        catch (Exception e) {
            return ErrorValue.get();
        }
    }

    public List<Token> getTokenList(String code) {
        this.lexer.setInputStream((IntStream)new ANTLRInputStream(code));
        this.lexer.reset();
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)this.lexer);
        tokenStream.fill();
        return tokenStream.getTokens();
    }

    @Override
    public void addListener(ILanguageErrorListener listener) {
        super.addListener(listener);
        this.antlrErrorListener.addListener(listener);
    }

    @Override
    public void removeListener(ILanguageErrorListener listener) {
        super.removeListener(listener);
        this.antlrErrorListener.addListener(listener);
    }

    @Override
    public void addListeners(Collection<ILanguageErrorListener> listeners) {
        super.addListeners(listeners);
        this.antlrErrorListener.addListeners(listeners);
    }

    @Override
    public void removeAllListeners() {
        super.removeAllListeners();
        this.antlrErrorListener.removeAllListeners();
    }
}

