/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.observation;

import org.jamesii.ml3.model.state.IState;
import org.jamesii.ml3.observation.AbstractObserver;
import org.jamesii.ml3.simulator.evaluate.StatementEvaluationProtocol;
import org.jamesii.ml3.simulator.simulators.RuleInstance;

public class WallclockIntervalObserver
extends AbstractObserver {
    private long intervalNanos;
    private long nextNanos;

    public WallclockIntervalObserver(long intervalNanos) {
        this.intervalNanos = intervalNanos;
        this.nextNanos = System.nanoTime() + intervalNanos;
    }

    @Override
    public void updateBefore(IState state, double now, double timeOfNextEvent, RuleInstance instance) {
    }

    @Override
    public void updateAfter(IState state, double now, RuleInstance instance, StatementEvaluationProtocol sep) {
        this.trigger(state, now, instance);
    }

    @Override
    public void finish(IState state, double now) {
        this.trigger(state, now, null);
        this.finishListeners();
    }

    private void trigger(IState state, double now, RuleInstance instance) {
        long nowNanos = System.nanoTime();
        if (nowNanos >= this.nextNanos) {
            this.notifyListeners(state, now, instance, null);
            this.nextNanos = nowNanos + this.intervalNanos;
        }
    }
}

