/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.observation;

import org.jamesii.ml3.model.state.IState;
import org.jamesii.ml3.observation.AbstractObserver;
import org.jamesii.ml3.simulator.evaluate.StatementEvaluationProtocol;
import org.jamesii.ml3.simulator.simulators.RuleInstance;

public abstract class TimeTriggeredObserver
extends AbstractObserver {
    private boolean finished;

    @Override
    public void updateBefore(IState state, double now, double timeOfNextEvent, RuleInstance instance) {
        if (!this.finished) {
            double nextObservationPoint = this.getNextObservationPoint();
            while (timeOfNextEvent > nextObservationPoint) {
                this.notifyListeners(state, nextObservationPoint, instance, null);
                this.advanceObservationPoint();
                nextObservationPoint = this.getNextObservationPoint();
            }
            if (Double.isInfinite(nextObservationPoint)) {
                this.finishListeners();
                this.finished = true;
            }
        }
    }

    @Override
    public void updateAfter(IState state, double now, RuleInstance instance, StatementEvaluationProtocol sep) {
    }

    @Override
    public void finish(IState state, double now) {
        if (!this.finished) {
            while (this.hasMandatoryNextObservationPoint()) {
                double nextObservationPoint = this.getNextObservationPoint();
                this.notifyListeners(state, nextObservationPoint, null, null);
                this.advanceObservationPoint();
            }
            this.finishListeners();
            this.finished = true;
        }
    }

    protected abstract double getNextObservationPoint();

    protected abstract boolean hasMandatoryNextObservationPoint();

    protected abstract void advanceObservationPoint();
}

