/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.observation;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jamesii.core.util.misc.Pair;
import org.jamesii.ml3.model.Model;
import org.jamesii.ml3.model.Parameters;
import org.jamesii.ml3.model.agents.IAgent;
import org.jamesii.ml3.model.state.IState;
import org.jamesii.ml3.model.values.AgentValue;
import org.jamesii.ml3.model.values.BoolValue;
import org.jamesii.ml3.model.values.IValue;
import org.jamesii.ml3.observation.IListener;
import org.jamesii.ml3.parser.ParserUtil;
import org.jamesii.ml3.parser.nodes.expressions.IExpression;
import org.jamesii.ml3.simulator.context.IContext;
import org.jamesii.ml3.simulator.context.SimpleContext;
import org.jamesii.ml3.simulator.evaluate.BasicExpressionEvaluator;
import org.jamesii.ml3.simulator.evaluate.IExpressionEvaluator;
import org.jamesii.ml3.simulator.simulators.RuleInstance;

public class ExpressionDistributionListener
implements IListener {
    private String agentType;
    private Consumer<Pair<Double, List<IValue>>> callback;
    private IExpression target;
    private IExpression filter;
    private IExpressionEvaluator exev;
    private IContext context;
    private boolean useFilter;

    public ExpressionDistributionListener(String agentType, Model model, Parameters parameters, String target, Consumer<Pair<Double, List<IValue>>> callback) {
        this.agentType = agentType;
        this.callback = callback;
        this.target = ParserUtil.parseExpressionCode(target);
        this.useFilter = false;
        this.exev = new BasicExpressionEvaluator();
        this.context = new SimpleContext();
        this.context.put((Object)IContext.Keys.MODEL, model);
        this.context.put((Object)IContext.Keys.EXPRESSION_EVALUATOR, this.exev);
        this.context.put((Object)IContext.Keys.PARAMETERS, parameters);
    }

    public ExpressionDistributionListener(String agentType, Model model, Parameters parameters, String target, String filter, Consumer<Pair<Double, List<IValue>>> callback) {
        this.agentType = agentType;
        this.callback = callback;
        this.target = ParserUtil.parseExpressionCode(target);
        this.filter = ParserUtil.parseExpressionCode(filter);
        this.useFilter = true;
        this.exev = new BasicExpressionEvaluator();
        this.context = new SimpleContext();
        this.context.put((Object)IContext.Keys.MODEL, model);
        this.context.put((Object)IContext.Keys.EXPRESSION_EVALUATOR, this.exev);
        this.context.put((Object)IContext.Keys.PARAMETERS, parameters);
    }

    @Override
    public void notify(IState state, double now, RuleInstance instance, IAgent agent) {
        ArrayList<IValue> callbackList = new ArrayList<IValue>();
        this.context.push();
        this.context.put((Object)IContext.Keys.TIME, now);
        if (this.useFilter) {
            this.context.push();
            this.context.put((Object)IContext.Keys.TIME, now);
            for (IAgent anAgent2 : state.getAgentsAliveByType(this.agentType)) {
                this.context.push();
                this.context.put((Object)IContext.Keys.EGO, new AgentValue(anAgent2));
                IValue filterValue = this.exev.getValue(this.filter, this.context);
                if (filterValue instanceof BoolValue && ((BoolValue)filterValue).getValue().booleanValue()) {
                    this.handleAgent(anAgent2, callbackList);
                }
                this.context.pop();
            }
            this.context.pop();
        } else {
            state.getAgentsAliveByType(this.agentType).forEach(anAgent -> this.handleAgent((IAgent)anAgent, (List<IValue>)callbackList));
        }
        this.context.pop();
        this.callback.accept(new Pair(now, callbackList));
    }

    private void handleAgent(IAgent agent, List<IValue> resultList) {
        this.context.push();
        this.context.put((Object)IContext.Keys.EGO, agent.asValue());
        resultList.add(this.exev.getValue(this.target, this.context));
        this.context.pop();
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void finish() {
    }
}

