/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.observation;

import java.util.function.Consumer;
import org.jamesii.core.util.misc.Pair;
import org.jamesii.ml3.model.Model;
import org.jamesii.ml3.model.Parameters;
import org.jamesii.ml3.model.agents.IAgent;
import org.jamesii.ml3.model.state.IState;
import org.jamesii.ml3.model.values.BoolValue;
import org.jamesii.ml3.model.values.IValue;
import org.jamesii.ml3.observation.IListener;
import org.jamesii.ml3.parser.ParserUtil;
import org.jamesii.ml3.parser.nodes.expressions.IExpression;
import org.jamesii.ml3.simulator.context.IContext;
import org.jamesii.ml3.simulator.context.SimpleContext;
import org.jamesii.ml3.simulator.evaluate.BasicExpressionEvaluator;
import org.jamesii.ml3.simulator.evaluate.IExpressionEvaluator;
import org.jamesii.ml3.simulator.simulators.RuleInstance;

public class AgentCountListener
implements IListener {
    private String agentType;
    private Consumer<Pair<Double, Integer>> callback;
    private IExpression filter;
    private IExpressionEvaluator exev;
    private IContext context;
    private boolean useFilter;

    public AgentCountListener(String agentType, Consumer<Pair<Double, Integer>> callback) {
        this.agentType = agentType;
        this.callback = callback;
        this.useFilter = false;
    }

    public AgentCountListener(String agentType, Model model, Parameters parameters, String filter, Consumer<Pair<Double, Integer>> callback) {
        this.agentType = agentType;
        this.callback = callback;
        this.filter = ParserUtil.parseExpressionCode(filter);
        this.useFilter = true;
        this.exev = new BasicExpressionEvaluator();
        this.context = new SimpleContext();
        this.context.put((Object)IContext.Keys.MODEL, model);
        this.context.put((Object)IContext.Keys.EXPRESSION_EVALUATOR, this.exev);
        this.context.put((Object)IContext.Keys.PARAMETERS, parameters);
    }

    @Override
    public void notify(IState state, double now, RuleInstance instance, IAgent agent) {
        if (this.useFilter) {
            this.context.push();
            this.context.put((Object)IContext.Keys.TIME, now);
            int count = 0;
            for (IAgent anAgent : state.getAgentsAliveByType(this.agentType)) {
                this.context.push();
                this.context.put((Object)IContext.Keys.EGO, anAgent.asValue());
                IValue filterValue = this.exev.getValue(this.filter, this.context);
                if (filterValue instanceof BoolValue && ((BoolValue)filterValue).getValue().booleanValue()) {
                    ++count;
                }
                this.context.pop();
            }
            this.context.pop();
            this.callback.accept(new Pair<Double, Integer>(now, count));
        } else {
            this.callback.accept(new Pair<Double, Integer>(now, state.getAgentsAliveByType(this.agentType).size()));
        }
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void finish() {
    }
}

