/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.model.values;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jamesii.ml3.model.types.BasicType;
import org.jamesii.ml3.model.types.IType;
import org.jamesii.ml3.model.types.SetType;
import org.jamesii.ml3.model.values.IValue;

public class SetValue
implements IValue {
    private final Set<IValue> value;

    public SetValue() {
        this.value = Collections.emptySet();
    }

    public <T extends IValue> SetValue(Collection<T> value) {
        this.value = value instanceof Set ? Collections.unmodifiableSet((Set)value) : Collections.unmodifiableSet(new HashSet<T>(value));
    }

    @Override
    public Set<IValue> getValue() {
        return this.value;
    }

    public int size() {
        return this.value.size();
    }

    @Override
    public IType getType() {
        return new SetType(BasicType.UNIVERSAL);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SetValue)) {
            return false;
        }
        SetValue value1 = (SetValue)o;
        return this.value.equals(value1.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value.toString();
    }
}

