/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.model.validation;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jamesii.ml3.model.Model;
import org.jamesii.ml3.model.agents.AgentDeclaration;
import org.jamesii.ml3.model.agents.FunctionDefinition;
import org.jamesii.ml3.model.validation.ITimeDependencyValidator;
import org.jamesii.ml3.model.validation.TimeDependency;
import org.jamesii.ml3.parser.BuildIns;
import org.jamesii.ml3.parser.nodes.expressions.AddExpression;
import org.jamesii.ml3.parser.nodes.expressions.AllAgentsExpression;
import org.jamesii.ml3.parser.nodes.expressions.AlterExpression;
import org.jamesii.ml3.parser.nodes.expressions.AndExpression;
import org.jamesii.ml3.parser.nodes.expressions.AttributeAccessExpression;
import org.jamesii.ml3.parser.nodes.expressions.ConditionalExpression;
import org.jamesii.ml3.parser.nodes.expressions.ConstExpression;
import org.jamesii.ml3.parser.nodes.expressions.DivideExpression;
import org.jamesii.ml3.parser.nodes.expressions.EgoExpression;
import org.jamesii.ml3.parser.nodes.expressions.EqualExpression;
import org.jamesii.ml3.parser.nodes.expressions.ErrorExpression;
import org.jamesii.ml3.parser.nodes.expressions.ExponentialExpression;
import org.jamesii.ml3.parser.nodes.expressions.FunctionCallExpression;
import org.jamesii.ml3.parser.nodes.expressions.IExpression;
import org.jamesii.ml3.parser.nodes.expressions.IExpressionVisitor;
import org.jamesii.ml3.parser.nodes.expressions.InExpression;
import org.jamesii.ml3.parser.nodes.expressions.MapConstantAccessExpression;
import org.jamesii.ml3.parser.nodes.expressions.ModuloExpression;
import org.jamesii.ml3.parser.nodes.expressions.MultiplyExpression;
import org.jamesii.ml3.parser.nodes.expressions.NowExpression;
import org.jamesii.ml3.parser.nodes.expressions.OrExpression;
import org.jamesii.ml3.parser.nodes.expressions.RelationalExpression;
import org.jamesii.ml3.parser.nodes.expressions.SetExpression;
import org.jamesii.ml3.parser.nodes.expressions.UnaryExpression;
import org.jamesii.ml3.parser.nodes.expressions.VariableAccessExpression;
import org.jamesii.ml3.simulator.exceptions.SimulationException;

public class BasicTimeDependencyValidator
implements ITimeDependencyValidator {
    private Map<IExpression, TimeDependency> cache = new HashMap<IExpression, TimeDependency>();
    private IExpressionVisitor<TimeDependency, Model> visitor = new IExpressionVisitor<TimeDependency, Model>(){

        @Override
        public TimeDependency visit(AddExpression e, Model m) {
            TimeDependency tdl = BasicTimeDependencyValidator.this.getTimeDependency(e.getLeftSummand(), m);
            TimeDependency tdr = BasicTimeDependencyValidator.this.getTimeDependency(e.getRightSummand(), m);
            if (tdl == TimeDependency.OTHER || tdr == TimeDependency.OTHER) {
                return TimeDependency.OTHER;
            }
            if (tdl == TimeDependency.PIECEWISE_CONSTANT || tdr == TimeDependency.PIECEWISE_CONSTANT) {
                return TimeDependency.PIECEWISE_CONSTANT;
            }
            return TimeDependency.CONSTANT;
        }

        @Override
        public TimeDependency visit(AllAgentsExpression e, Model m) {
            return TimeDependency.CONSTANT;
        }

        @Override
        public TimeDependency visit(AlterExpression e, Model m) {
            return TimeDependency.CONSTANT;
        }

        @Override
        public TimeDependency visit(AndExpression e, Model m) {
            TimeDependency tdl = BasicTimeDependencyValidator.this.getTimeDependency(e.getLeftExpression(), m);
            TimeDependency tdr = BasicTimeDependencyValidator.this.getTimeDependency(e.getRightExpression(), m);
            if (tdl == TimeDependency.CONSTANT && tdr == TimeDependency.CONSTANT) {
                return TimeDependency.CONSTANT;
            }
            return TimeDependency.PIECEWISE_CONSTANT;
        }

        @Override
        public TimeDependency visit(AttributeAccessExpression e, Model m) {
            TimeDependency td = BasicTimeDependencyValidator.this.getTimeDependency(e.getBaseExpression(), m);
            if (e.getAttributeName().equals("age")) {
                return TimeDependency.OTHER;
            }
            return td;
        }

        @Override
        public TimeDependency visit(ConditionalExpression e, Model m) {
            TimeDependency tdc = BasicTimeDependencyValidator.this.getTimeDependency(e.getCondition(), m);
            TimeDependency tdt = BasicTimeDependencyValidator.this.getTimeDependency(e.getThenExpression(), m);
            TimeDependency tde = e.getElseExpression() != null ? BasicTimeDependencyValidator.this.getTimeDependency(e.getElseExpression(), m) : TimeDependency.CONSTANT;
            TimeDependency tdPaths = tdt.combineWith(tde);
            if (tdc == TimeDependency.CONSTANT) {
                return tdPaths;
            }
            return tdPaths.combineWith(TimeDependency.PIECEWISE_CONSTANT);
        }

        @Override
        public TimeDependency visit(ConstExpression e, Model m) {
            return TimeDependency.CONSTANT;
        }

        @Override
        public TimeDependency visit(DivideExpression e, Model m) {
            TimeDependency tdl = BasicTimeDependencyValidator.this.getTimeDependency(e.getDividend(), m);
            TimeDependency tdr = BasicTimeDependencyValidator.this.getTimeDependency(e.getDivisor(), m);
            if (tdl == TimeDependency.OTHER || tdr == TimeDependency.OTHER) {
                return TimeDependency.OTHER;
            }
            if (tdl == TimeDependency.PIECEWISE_CONSTANT || tdr == TimeDependency.PIECEWISE_CONSTANT) {
                return TimeDependency.PIECEWISE_CONSTANT;
            }
            return TimeDependency.CONSTANT;
        }

        @Override
        public TimeDependency visit(EgoExpression e, Model m) {
            return TimeDependency.CONSTANT;
        }

        @Override
        public TimeDependency visit(EqualExpression e, Model m) {
            TimeDependency tdl = BasicTimeDependencyValidator.this.getTimeDependency(e.getLeftExpression(), m);
            TimeDependency tdr = BasicTimeDependencyValidator.this.getTimeDependency(e.getRightExpression(), m);
            if (tdl == TimeDependency.CONSTANT && tdr == TimeDependency.CONSTANT) {
                return TimeDependency.CONSTANT;
            }
            return TimeDependency.PIECEWISE_CONSTANT;
        }

        @Override
        public TimeDependency visit(FunctionCallExpression e, Model m) {
            TimeDependency tdp = TimeDependency.CONSTANT;
            for (IExpression parameter : e.getParameters()) {
                tdp = tdp.combineWith(BasicTimeDependencyValidator.this.getTimeDependency(parameter, m));
            }
            String name = e.getFunctionName();
            if (e.getBaseExpression() == null) {
                if (BuildIns.isMathFunction(name)) {
                    return tdp;
                }
                throw new SimulationException("Call to an undefined function: " + e);
            }
            TimeDependency tdb = BasicTimeDependencyValidator.this.getTimeDependency(e.getBaseExpression(), m);
            boolean isDefined = false;
            FunctionDefinition definition = null;
            Iterator<AgentDeclaration> itAd = m.getAgentDeclarations().iterator();
            while (!isDefined && itAd.hasNext()) {
                AgentDeclaration ad = itAd.next();
                Iterator<FunctionDefinition> itFd = ad.getFunctions().iterator();
                while (!isDefined && itFd.hasNext()) {
                    FunctionDefinition fd = itFd.next();
                    if (!fd.getName().equals(name) || fd.getParameterNames().size() != e.getParameters().size()) continue;
                    isDefined = true;
                    definition = fd;
                }
            }
            BasicTimeDependencyValidator.this.cache.put(e, tdp.combineWith(tdb));
            if (isDefined) {
                TimeDependency tde = BasicTimeDependencyValidator.this.getTimeDependency(definition.getExpression(), m);
                return tdb.combineWith(tde).combineWith(tdp);
            }
            if (BuildIns.isNonMathPredefinedFunction(name)) {
                return tdb.combineWith(tdp);
            }
            if (name.startsWith("has") && name.length() >= 4 && e.getParameters().size() == 0) {
                return tdb.combineWith(tdp);
            }
            throw new SimulationException("Call to an undefined function: " + e);
        }

        @Override
        public TimeDependency visit(InExpression e, Model m) {
            TimeDependency tdl = BasicTimeDependencyValidator.this.getTimeDependency(e.getElement(), m);
            TimeDependency tdr = BasicTimeDependencyValidator.this.getTimeDependency(e.getList(), m);
            if (tdl == TimeDependency.CONSTANT && tdr == TimeDependency.CONSTANT) {
                return TimeDependency.CONSTANT;
            }
            return TimeDependency.PIECEWISE_CONSTANT;
        }

        @Override
        public TimeDependency visit(SetExpression e, Model m) {
            TimeDependency mostGeneral = TimeDependency.CONSTANT;
            for (IExpression exp : e.getExpressions()) {
                TimeDependency td = BasicTimeDependencyValidator.this.getTimeDependency(exp, m);
                if (td == TimeDependency.OTHER) {
                    return td;
                }
                if (td != TimeDependency.PIECEWISE_CONSTANT) continue;
                mostGeneral = td;
            }
            return mostGeneral;
        }

        @Override
        public TimeDependency visit(MapConstantAccessExpression e, Model m) {
            TimeDependency td = BasicTimeDependencyValidator.this.getTimeDependency(e.getParameter(), m);
            if (td == TimeDependency.CONSTANT) {
                return TimeDependency.CONSTANT;
            }
            return TimeDependency.PIECEWISE_CONSTANT;
        }

        @Override
        public TimeDependency visit(ModuloExpression e, Model m) {
            TimeDependency tdl = BasicTimeDependencyValidator.this.getTimeDependency(e.getDividend(), m);
            TimeDependency tdr = BasicTimeDependencyValidator.this.getTimeDependency(e.getDivisor(), m);
            if (tdl == TimeDependency.OTHER || tdr == TimeDependency.OTHER) {
                return TimeDependency.OTHER;
            }
            if (tdl == TimeDependency.PIECEWISE_CONSTANT || tdr == TimeDependency.PIECEWISE_CONSTANT) {
                return TimeDependency.PIECEWISE_CONSTANT;
            }
            return TimeDependency.CONSTANT;
        }

        @Override
        public TimeDependency visit(MultiplyExpression e, Model m) {
            TimeDependency tdl = BasicTimeDependencyValidator.this.getTimeDependency(e.getLeftFactor(), m);
            TimeDependency tdr = BasicTimeDependencyValidator.this.getTimeDependency(e.getRightFactor(), m);
            if (tdl == TimeDependency.OTHER || tdr == TimeDependency.OTHER) {
                return TimeDependency.OTHER;
            }
            if (tdl == TimeDependency.PIECEWISE_CONSTANT || tdr == TimeDependency.PIECEWISE_CONSTANT) {
                return TimeDependency.PIECEWISE_CONSTANT;
            }
            return TimeDependency.CONSTANT;
        }

        @Override
        public TimeDependency visit(ExponentialExpression e, Model m) {
            TimeDependency tdl = BasicTimeDependencyValidator.this.getTimeDependency(e.getBase(), m);
            TimeDependency tdr = BasicTimeDependencyValidator.this.getTimeDependency(e.getExponent(), m);
            if (tdl == TimeDependency.OTHER || tdr == TimeDependency.OTHER) {
                return TimeDependency.OTHER;
            }
            if (tdl == TimeDependency.PIECEWISE_CONSTANT || tdr == TimeDependency.PIECEWISE_CONSTANT) {
                return TimeDependency.PIECEWISE_CONSTANT;
            }
            return TimeDependency.CONSTANT;
        }

        @Override
        public TimeDependency visit(NowExpression e, Model m) {
            return TimeDependency.OTHER;
        }

        @Override
        public TimeDependency visit(OrExpression e, Model m) {
            TimeDependency tdl = BasicTimeDependencyValidator.this.getTimeDependency(e.getLeftExpression(), m);
            TimeDependency tdr = BasicTimeDependencyValidator.this.getTimeDependency(e.getRightExpression(), m);
            if (tdl == TimeDependency.CONSTANT && tdr == TimeDependency.CONSTANT) {
                return TimeDependency.CONSTANT;
            }
            return TimeDependency.PIECEWISE_CONSTANT;
        }

        @Override
        public TimeDependency visit(RelationalExpression e, Model m) {
            TimeDependency tdl = BasicTimeDependencyValidator.this.getTimeDependency(e.getLeftExpression(), m);
            TimeDependency tdr = BasicTimeDependencyValidator.this.getTimeDependency(e.getRightExpression(), m);
            if (tdl == TimeDependency.CONSTANT && tdr == TimeDependency.CONSTANT) {
                return TimeDependency.CONSTANT;
            }
            return TimeDependency.PIECEWISE_CONSTANT;
        }

        @Override
        public TimeDependency visit(UnaryExpression e, Model m) {
            return BasicTimeDependencyValidator.this.getTimeDependency(e.getExpression(), m);
        }

        @Override
        public TimeDependency visit(VariableAccessExpression e, Model m) {
            return TimeDependency.CONSTANT;
        }

        @Override
        public TimeDependency visit(ErrorExpression e, Model p) {
            return TimeDependency.OTHER;
        }
    };

    @Override
    public boolean isTimeDependent(IExpression e, Model m) {
        return this.getTimeDependency(e, m) != TimeDependency.CONSTANT;
    }

    @Override
    public TimeDependency getTimeDependency(IExpression e, Model m) {
        if (this.cache.containsKey(e)) {
            return this.cache.get(e);
        }
        TimeDependency td = e.accept(this.visitor, m);
        this.cache.put(e, td);
        return td;
    }
}

