/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.model.types;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jamesii.ml3.model.types.IType;
import org.jamesii.ml3.model.values.IValue;

public final class UnknownType
implements IType {
    public static UnknownType ANY_TYPE = new UnknownType(new IType[0]);
    private final Set<IType> potentialTypes;

    public UnknownType(IType ... potentialTypes) {
        assert (potentialTypes.length != 0);
        HashSet typesSet = new HashSet();
        Collections.addAll(typesSet, potentialTypes);
        this.potentialTypes = Collections.unmodifiableSet(typesSet);
    }

    public UnknownType(Set<IType> potentialTypes) {
        this.potentialTypes = Collections.unmodifiableSet(new HashSet<IType>(potentialTypes));
    }

    public Set<IType> getPotentialTypes() {
        return this.potentialTypes;
    }

    @Override
    public IValue getDefaultValue() {
        return null;
    }

    @Override
    public boolean isValidValue(IValue value) {
        return false;
    }

    @Override
    public boolean areCompatible(IType type) {
        return this.potentialTypes.contains(type);
    }

    public String toString() {
        String s = "UNKNOWN-TYPE";
        for (IType i : this.potentialTypes) {
            s = s + ":" + i.toString();
        }
        return s;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnknownType)) {
            return false;
        }
        UnknownType type = (UnknownType)o;
        return this.potentialTypes.equals(type.potentialTypes);
    }

    public int hashCode() {
        return this.potentialTypes.hashCode();
    }
}

