/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.model.types;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jamesii.ml3.model.types.BasicType;
import org.jamesii.ml3.model.types.IType;
import org.jamesii.ml3.model.values.IValue;
import org.jamesii.ml3.model.values.StringValue;

public final class EnumType
implements IType {
    private final Set<String> validValues;

    public EnumType(Set<String> validValues) {
        assert (!validValues.isEmpty());
        this.validValues = new HashSet<String>(validValues);
    }

    public EnumType(String ... validValues) {
        assert (validValues.length > 0);
        this.validValues = new HashSet<String>();
        Collections.addAll(this.validValues, validValues);
    }

    @Override
    public boolean isValidValue(IValue value) {
        return value instanceof StringValue && this.validValues.contains(((StringValue)value).getValue());
    }

    @Override
    public boolean areCompatible(IType type) {
        return type.equals(BasicType.STRING);
    }

    @Override
    public IValue getDefaultValue() {
        return new StringValue(this.validValues.iterator().next());
    }

    public String toString() {
        String ret = "";
        for (String s : this.validValues) {
            ret = ret == "" ? "{\"" + s + "\"" : ret + ", \"" + s + "\"";
        }
        ret = ret + "}";
        return ret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EnumType)) {
            return false;
        }
        EnumType type = (EnumType)o;
        return this.validValues.equals(type.validValues);
    }

    public int hashCode() {
        return this.validValues.hashCode();
    }
}

