/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.model.types;

import org.jamesii.ml3.model.types.IType;
import org.jamesii.ml3.model.values.BoolValue;
import org.jamesii.ml3.model.values.IValue;
import org.jamesii.ml3.model.values.IntValue;
import org.jamesii.ml3.model.values.RealValue;
import org.jamesii.ml3.model.values.StringValue;

public enum BasicType implements IType
{
    UNIVERSAL{

        @Override
        public IValue getDefaultValue() {
            return null;
        }

        @Override
        public boolean isValidValue(IValue value) {
            return true;
        }

        @Override
        public boolean areCompatible(IType type) {
            return true;
        }
    }
    ,
    STRING{

        @Override
        public IValue getDefaultValue() {
            return new StringValue("");
        }

        @Override
        public boolean isValidValue(IValue value) {
            return value instanceof StringValue;
        }

        @Override
        public boolean areCompatible(IType type) {
            return true;
        }

        @Override
        public String toString() {
            return "string";
        }
    }
    ,
    INT{

        @Override
        public IValue getDefaultValue() {
            return new IntValue(0);
        }

        @Override
        public boolean isValidValue(IValue value) {
            return value instanceof IntValue;
        }

        @Override
        public boolean areCompatible(IType type) {
            return type.equals(INT) || type.equals(REAL);
        }

        @Override
        public String toString() {
            return "int";
        }
    }
    ,
    REAL{

        @Override
        public IValue getDefaultValue() {
            return new RealValue(0.0);
        }

        @Override
        public boolean isValidValue(IValue value) {
            return value instanceof RealValue || value instanceof IntValue;
        }

        @Override
        public boolean areCompatible(IType type) {
            return type.equals(REAL) | type.equals(INT);
        }

        @Override
        public String toString() {
            return "real";
        }
    }
    ,
    BOOL{

        @Override
        public IValue getDefaultValue() {
            return BoolValue.FALSE;
        }

        @Override
        public boolean isValidValue(IValue value) {
            return value instanceof BoolValue;
        }

        @Override
        public boolean areCompatible(IType type) {
            return type.equals(BOOL);
        }

        @Override
        public String toString() {
            return "bool";
        }
    };


    public String toString() {
        return this.name();
    }
}

