/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.model.state.writers;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jamesii.ml3.model.Model;
import org.jamesii.ml3.model.agents.AgentDeclaration;
import org.jamesii.ml3.model.agents.AttributeDeclaration;
import org.jamesii.ml3.model.agents.IAgent;
import org.jamesii.ml3.model.agents.LinkDeclaration;
import org.jamesii.ml3.model.state.IState;
import org.jamesii.ml3.model.state.writers.AbstractStateWriter;
import org.jamesii.ml3.model.state.writers.StateWriteException;
import org.jamesii.ml3.model.types.BasicType;
import org.jamesii.ml3.model.types.IType;
import org.jamesii.ml3.model.values.IValue;
import org.jamesii.ml3.model.values.StringValue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class GraphMLStateWriter
extends AbstractStateWriter {
    private Model model;

    public GraphMLStateWriter(String pattern, Model model) {
        super(pattern);
        this.model = model;
    }

    public GraphMLStateWriter(File file, Model model) throws IOException {
        super(file);
        this.model = model;
    }

    public GraphMLStateWriter(OutputStream out, Model model) {
        super(out);
        this.model = model;
    }

    @Override
    protected void write(OutputStream outputStream, IState state, double now) throws StateWriteException {
        Document doc = this.createDocument();
        Element root = this.createRoot(doc);
        this.defineKeys(doc, root);
        Element graph = this.createGraph(doc, root);
        this.createNodes(doc, root, state, now);
        this.writeResult(doc, outputStream);
    }

    private Document createDocument() throws StateWriteException {
        DocumentBuilder docBuilder;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        try {
            docBuilder = docFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new StateWriteException(e);
        }
        return docBuilder.newDocument();
    }

    private Element createRoot(Document doc) {
        Element root = doc.createElement("graphml");
        doc.appendChild(root);
        root.setAttribute("xmlns", "http://graphml.graphdrawing.org/xmlns");
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttribute("xsi:schemaLocation", "http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd");
        return root;
    }

    private void defineKeys(Document doc, Element root) {
        this.defineKey(doc, root, "k_link", "edge", "role", "string");
        this.defineKey(doc, root, "k_type", "node", "type", "string");
        for (AgentDeclaration ad : this.model.getAgentDeclarations()) {
            for (AttributeDeclaration attribute : ad.getAttributes()) {
                this.defineKey(doc, root, this.ml3AttrToGraphMLKey(ad.getName(), attribute.getName()), "node", this.ml3AttrToGraphMLAttr(ad.getName(), attribute.getName()), this.ml3TypeToGraphMLType(attribute.getType()));
            }
        }
        this.defineKey(doc, root, "k_age", "node", "age", "double");
        this.defineKey(doc, root, "k_alive", "node", "alive", "boolean");
    }

    private String ml3AttrToGraphMLAttr(String agentType, String attr) {
        return agentType + ":" + attr;
    }

    private String ml3AttrToGraphMLKey(String agentType, String attr) {
        return "k_" + agentType + ":" + attr;
    }

    private String ml3TypeToGraphMLType(IType type) {
        if (type.equals(BasicType.INT)) {
            return "int";
        }
        if (type.equals(BasicType.REAL)) {
            return "double";
        }
        if (type.equals(BasicType.BOOL)) {
            return "boolean";
        }
        return "string";
    }

    private void defineKey(Document doc, Element root, String id, String kind, String name, String type) {
        Element key = doc.createElement("key");
        root.appendChild(key);
        key.setAttribute("id", id);
        key.setAttribute("for", kind);
        key.setAttribute("attr.name", name);
        key.setAttribute("attr.type", type);
    }

    private Element createGraph(Document doc, Element root) {
        Element graph = doc.createElement("graph");
        root.appendChild(graph);
        graph.setAttribute("id", "G");
        graph.setAttribute("edgedefault", "directed");
        return graph;
    }

    private void createNodes(Document doc, Element graph, IState state, double now) {
        Collection<IAgent> agents = state.getAgents();
        ArrayList<Element> nodes = new ArrayList<Element>();
        ArrayList<Element> edges = new ArrayList<Element>();
        int lastEdgeID = 0;
        for (IAgent agent : agents) {
            Element node = doc.createElement("node");
            node.setAttribute("id", "" + agent.getID());
            this.addData(doc, node, "k_type", agent.getType());
            this.addData(doc, node, "k_age", "" + agent.getAge(now));
            this.addData(doc, node, "k_alive", "" + agent.isAlive());
            for (String attribute : agent.getAttributes().keySet()) {
                IValue v = agent.getAttributeValue(attribute);
                String attrString = v instanceof StringValue ? ((StringValue)v).getValue() : v.toString();
                this.addData(doc, node, this.ml3AttrToGraphMLKey(agent.getType(), attribute), attrString);
            }
            nodes.add(node);
            AgentDeclaration agentDeclaration = this.model.getAgentDeclaration(agent.getType());
            for (LinkDeclaration linkDeclaration : agentDeclaration.getLinks()) {
                String name = linkDeclaration.getPartnerRole();
                Collection<IAgent> partners = agent.getLinkedAgents(name);
                for (IAgent parnet : partners) {
                    Element edge = doc.createElement("edge");
                    edge.setAttribute("id", "e" + lastEdgeID++);
                    edge.setAttribute("source", "" + agent.getID());
                    edge.setAttribute("target", "" + parnet.getID());
                    this.addData(doc, edge, "k_link", name);
                    edges.add(edge);
                }
            }
        }
        for (Element node : nodes) {
            graph.appendChild(node);
        }
        for (Element edge : edges) {
            graph.appendChild(edge);
        }
    }

    private void writeResult(Document doc, OutputStream outputStream) throws StateWriteException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        }
        catch (TransformerConfigurationException e) {
            throw new StateWriteException(e);
        }
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(new OutputStreamWriter(outputStream, Charset.forName("UTF-8")));
        try {
            transformer.transform(source, result);
        }
        catch (NullPointerException | TransformerException e) {
            throw new StateWriteException(e);
        }
    }

    private void addData(Document doc, Node n, String key, String value) {
        Element data = doc.createElement("data");
        data.setAttribute("key", key);
        Text text = doc.createTextNode(value);
        data.appendChild(text);
        n.appendChild(data);
    }
}

