/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.model.state.writers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jamesii.ml3.model.state.IState;
import org.jamesii.ml3.model.state.writers.IStateWriter;
import org.jamesii.ml3.model.state.writers.StateWriteException;

public abstract class AbstractStateWriter
implements IStateWriter {
    private String pattern;
    private OutputStream outputStream;
    private boolean hasOS;

    public AbstractStateWriter(String pattern) {
        this.pattern = pattern;
        this.hasOS = false;
    }

    public AbstractStateWriter(File file) throws IOException {
        this.outputStream = new FileOutputStream(file);
        this.hasOS = true;
    }

    public AbstractStateWriter(OutputStream out) {
        this.outputStream = out;
        this.hasOS = true;
    }

    @Override
    public void write(IState state, double now) throws StateWriteException {
        if (this.hasOS) {
            this.write(this.outputStream, state, now);
        } else {
            String path = this.pattern.replaceAll("\\$time", String.format("%.0f", now));
            try {
                FileOutputStream thisWriter = new FileOutputStream(path);
                this.write(thisWriter, state, now);
                ((OutputStream)thisWriter).close();
            }
            catch (IOException e) {
                throw new StateWriteException(e);
            }
        }
    }

    @Override
    public void close() throws StateWriteException {
        try {
            if (this.hasOS) {
                this.outputStream.close();
            }
        }
        catch (IOException e) {
            throw new StateWriteException(e);
        }
    }

    protected abstract void write(OutputStream var1, IState var2, double var3) throws StateWriteException;
}

