/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.model.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jamesii.ml3.model.agents.IAgent;
import org.jamesii.ml3.model.state.IState;

public class SimpleState
implements IState {
    private Map<Integer, IAgent> agentsAlive = new HashMap<Integer, IAgent>();
    private Map<Integer, IAgent> agentsDead = new HashMap<Integer, IAgent>();

    @Override
    public Collection<IAgent> getAgents() {
        ArrayList<IAgent> all = new ArrayList<IAgent>();
        all.addAll(this.agentsAlive.values());
        all.addAll(this.agentsDead.values());
        return all;
    }

    @Override
    public Collection<IAgent> getAgentsByType(String type) {
        Collection<IAgent> all = this.getAgentsAliveByType(type);
        for (IAgent agent : this.agentsDead.values()) {
            if (!agent.getType().equals(type)) continue;
            all.add(agent);
        }
        return all;
    }

    @Override
    public Collection<IAgent> getAgentsAlive() {
        return this.agentsAlive.values();
    }

    @Override
    public Collection<IAgent> getAgentsAliveByType(String type) {
        ArrayList<IAgent> all = new ArrayList<IAgent>();
        for (IAgent agent : this.agentsAlive.values()) {
            if (!agent.getType().equals(type)) continue;
            all.add(agent);
        }
        return all;
    }

    @Override
    public void addAgent(IAgent agent) {
        if (agent.isAlive()) {
            this.agentsAlive.put(agent.getID(), agent);
        } else {
            this.agentsDead.put(agent.getID(), agent);
        }
    }

    @Override
    public void addAgents(Collection<IAgent> agents) {
        for (IAgent agent : agents) {
            this.addAgent(agent);
        }
    }

    @Override
    public IAgent getAgent(int id) {
        if (this.agentsAlive.containsKey(id)) {
            return this.agentsAlive.get(id);
        }
        return this.agentsDead.get(id);
    }

    @Override
    public void killAgent(int id, double time) {
        if (this.agentsAlive.containsKey(id)) {
            IAgent agent = this.agentsAlive.get(id);
            agent.die(time);
            this.agentsAlive.remove(id);
            this.agentsDead.put(id, agent);
        }
    }
}

