/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.model.state;

import org.apache.commons.math3.random.RandomGenerator;
import org.jamesii.ml3.model.Model;
import org.jamesii.ml3.model.Parameters;
import org.jamesii.ml3.model.state.IState;
import org.jamesii.ml3.model.state.IStateFactory;
import org.jamesii.ml3.parser.ParserUtil;
import org.jamesii.ml3.parser.nodes.statements.IStatement;
import org.jamesii.ml3.simulator.context.IContext;
import org.jamesii.ml3.simulator.context.SimpleContext;
import org.jamesii.ml3.simulator.evaluate.BasicExpressionEvaluator;
import org.jamesii.ml3.simulator.evaluate.BasicStatementEvaluator;

public abstract class AbstractStateFactory
implements IStateFactory {
    @Override
    public IState create(String statement, Model model, RandomGenerator rng, Parameters params, double time) {
        return this.create(ParserUtil.parseStatementCode(statement), model, rng, params, time);
    }

    @Override
    public IState create(IStatement statement, Model model, RandomGenerator rng, Parameters params, double time) {
        IState state = this.create();
        SimpleContext context = new SimpleContext();
        BasicExpressionEvaluator exev = new BasicExpressionEvaluator();
        BasicStatementEvaluator stev = new BasicStatementEvaluator();
        context.put((Object)IContext.Keys.AGENT_FACTORY, this.getAgentFactory());
        context.put((Object)IContext.Keys.STATE, state);
        context.put((Object)IContext.Keys.MODEL, model);
        context.put((Object)IContext.Keys.RANDOM, rng);
        context.put((Object)IContext.Keys.EXPRESSION_EVALUATOR, exev);
        context.put((Object)IContext.Keys.STATEMENT_EVALUATOR, stev);
        context.put((Object)IContext.Keys.PARAMETERS, params);
        context.put((Object)IContext.Keys.TIME, time);
        stev.evaluate(statement, context);
        return (IState)context.get((Object)IContext.Keys.STATE);
    }

    @Override
    public IState createFromFile(String path, Model model, RandomGenerator rng, Parameters params, double time) {
        return this.create(ParserUtil.parseStatementFile(path), model, rng, params, time);
    }
}

