/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.model.build;

import java.util.ArrayList;
import java.util.List;
import org.jamesii.ml3.model.Model;
import org.jamesii.ml3.model.agents.AgentDeclaration;
import org.jamesii.ml3.model.agents.AttributeDeclaration;
import org.jamesii.ml3.model.agents.FunctionDefinition;
import org.jamesii.ml3.model.agents.LinkDeclaration;
import org.jamesii.ml3.model.agents.ProcedureDefinition;
import org.jamesii.ml3.model.agents.rules.Rule;
import org.jamesii.ml3.model.agents.rules.RuleInstanciation;
import org.jamesii.ml3.model.agents.rules.VariableBinding;
import org.jamesii.ml3.model.agents.rules.rates.AgeRate;
import org.jamesii.ml3.model.agents.rules.rates.EveryRate;
import org.jamesii.ml3.model.agents.rules.rates.EverySynchronizedRate;
import org.jamesii.ml3.model.agents.rules.rates.IRate;
import org.jamesii.ml3.model.agents.rules.rates.InstantlyRate;
import org.jamesii.ml3.model.agents.rules.rates.PiecewiseConstantRate;
import org.jamesii.ml3.model.agents.rules.rates.TimeIndependentRate;
import org.jamesii.ml3.model.types.IType;
import org.jamesii.ml3.model.types.SetType;
import org.jamesii.ml3.model.validation.BasicTimeDependencyValidator;
import org.jamesii.ml3.model.validation.ITimeDependencyValidator;
import org.jamesii.ml3.model.values.BoolValue;
import org.jamesii.ml3.model.values.IValue;
import org.jamesii.ml3.model.values.RealValue;
import org.jamesii.ml3.parser.nodes.AgeRateNode;
import org.jamesii.ml3.parser.nodes.AgentDeclarationNode;
import org.jamesii.ml3.parser.nodes.AttributeDeclarationNode;
import org.jamesii.ml3.parser.nodes.EveryRateNode;
import org.jamesii.ml3.parser.nodes.EverySynchronizedRateNode;
import org.jamesii.ml3.parser.nodes.ForEachNode;
import org.jamesii.ml3.parser.nodes.FunctionDeclarationNode;
import org.jamesii.ml3.parser.nodes.IRateNode;
import org.jamesii.ml3.parser.nodes.InstantlyNode;
import org.jamesii.ml3.parser.nodes.LinkDeclarationNode;
import org.jamesii.ml3.parser.nodes.ModelNode;
import org.jamesii.ml3.parser.nodes.ParameterDeclarationNode;
import org.jamesii.ml3.parser.nodes.ProcedureDeclarationNode;
import org.jamesii.ml3.parser.nodes.RateExpressionNode;
import org.jamesii.ml3.parser.nodes.RuleDeclarationsNode;
import org.jamesii.ml3.parser.nodes.RuleNode;
import org.jamesii.ml3.parser.nodes.expressions.AndExpression;
import org.jamesii.ml3.parser.nodes.expressions.ConditionalExpression;
import org.jamesii.ml3.parser.nodes.expressions.ConstExpression;
import org.jamesii.ml3.parser.nodes.expressions.IExpression;
import org.jamesii.ml3.parser.nodes.statements.IStatement;

public class ModelBuilder {
    private int lastID;
    private ITimeDependencyValidator tdv = new BasicTimeDependencyValidator();

    private int newID() {
        ++this.lastID;
        return this.lastID;
    }

    public Model build(ModelNode m) {
        AgentDeclaration agentType;
        Model model = new Model();
        for (AgentDeclarationNode agentDeclaration : m.getAgentDeclarations()) {
            agentType = new AgentDeclaration(agentDeclaration.agentType);
            model.addAgentDeclaration(agentType);
            List<AttributeDeclarationNode> attributeDeclarations = agentDeclaration.getAttributes();
            for (AttributeDeclarationNode attributeDeclaration : attributeDeclarations) {
                agentType.addAttribute(this.build(attributeDeclaration));
            }
        }
        for (FunctionDeclarationNode functionDeclaration : m.getFunctionDeclarations()) {
            agentType = model.getAgentDeclaration(functionDeclaration.getAgentType());
            agentType.addFunction(this.build(functionDeclaration));
        }
        for (ProcedureDeclarationNode procedureDeclaration : m.getProcedureDeclarations()) {
            agentType = model.getAgentDeclaration(procedureDeclaration.getAgentType());
            agentType.addProcedure(this.build(procedureDeclaration));
        }
        for (LinkDeclarationNode linkDeclaration : m.getLinkDeclarations()) {
            AgentDeclaration agentTypeLeft = model.getAgentDeclaration(linkDeclaration.getLeftAgentType());
            AgentDeclaration agentTypeRight = model.getAgentDeclaration(linkDeclaration.getRightAgentType());
            agentTypeLeft.addLink(new LinkDeclaration(linkDeclaration.getLeftRoleName(), linkDeclaration.getRightRoleName(), SetType.fromLink(linkDeclaration.getRightAgentType(), linkDeclaration.getRightCardinality())));
            agentTypeRight.addLink(new LinkDeclaration(linkDeclaration.getRightRoleName(), linkDeclaration.getLeftRoleName(), SetType.fromLink(linkDeclaration.getLeftAgentType(), linkDeclaration.getLeftCardinality())));
        }
        for (RuleDeclarationsNode ruleDeclaration : m.getRuleDeclarations()) {
            agentType = model.getAgentDeclaration(ruleDeclaration.getAgentType());
            for (RuleNode agentRule : ruleDeclaration.getRules()) {
                agentType.addRule(this.build(agentRule, model));
            }
        }
        return model;
    }

    private FunctionDefinition build(FunctionDeclarationNode funDec) {
        String name = funDec.getFunctionName();
        IExpression expression = funDec.getExpression();
        ArrayList<String> parameterNames = new ArrayList<String>(funDec.getParameters().size());
        for (ParameterDeclarationNode paramDec : funDec.getParameters()) {
            parameterNames.add(paramDec.getParameterName());
        }
        ArrayList<VariableBinding> where = new ArrayList<VariableBinding>();
        if (funDec.getWhereClause() != null) {
            for (String vd : funDec.getWhereClause().getVariables().keySet()) {
                where.add(new VariableBinding(vd, funDec.getWhereClause().getVariables().get(vd)));
            }
        }
        return new FunctionDefinition(name, parameterNames, expression, where);
    }

    private ProcedureDefinition build(ProcedureDeclarationNode procDec) {
        String name = procDec.getProcedureName();
        IStatement statement = procDec.getStatement();
        ArrayList<String> parameterNames = new ArrayList<String>(procDec.getParameters().size());
        for (ParameterDeclarationNode paramDec : procDec.getParameters()) {
            parameterNames.add(paramDec.getParameterName());
        }
        ArrayList<VariableBinding> where = new ArrayList<VariableBinding>();
        if (procDec.getWhereClause() != null) {
            for (String vd : procDec.getWhereClause().getVariables().keySet()) {
                where.add(new VariableBinding(vd, procDec.getWhereClause().getVariables().get(vd)));
            }
        }
        return new ProcedureDefinition(name, parameterNames, statement, where);
    }

    private Rule build(RuleNode agentRule, Model model) {
        IExpression guard;
        int id = this.newID();
        IStatement statement = agentRule.getStatement();
        IRate rate = null;
        if (!(agentRule.getRate() instanceof RateExpressionNode)) {
            guard = agentRule.getGuard() == null ? new ConstExpression(null, BoolValue.TRUE) : this.andMergeExpressions(agentRule.getGuard().getExpressions());
            rate = this.build(agentRule.getRate(), model);
        } else {
            IExpression rateExpression;
            if (agentRule.getGuard() == null) {
                guard = new ConstExpression(null, BoolValue.TRUE);
                rateExpression = ((RateExpressionNode)agentRule.getRate()).getExpression();
            } else {
                Pair<IExpression, IExpression> pair = this.andMergeWithRateExpression(agentRule.getGuard().getExpressions(), ((RateExpressionNode)agentRule.getRate()).getExpression(), model);
                guard = pair.getFirst();
                rateExpression = pair.getSecond();
            }
            rate = this.tdv.isTimeDependent(rateExpression, model) ? new PiecewiseConstantRate(rateExpression) : new TimeIndependentRate(rateExpression);
        }
        ArrayList<RuleInstanciation> forEach = new ArrayList<RuleInstanciation>();
        if (agentRule.getForEachs() != null) {
            for (ForEachNode fen : agentRule.getForEachs()) {
                forEach.add(new RuleInstanciation(fen.getVariableName(), fen.getExpression()));
            }
        }
        ArrayList<VariableBinding> where = new ArrayList<VariableBinding>();
        if (agentRule.getWhereClause() != null) {
            for (String vd : agentRule.getWhereClause().getVariables().keySet()) {
                where.add(new VariableBinding(vd, agentRule.getWhereClause().getVariables().get(vd)));
            }
        }
        return new Rule(id, guard, rate, statement, forEach, where);
    }

    private IRate build(IRateNode rate, Model model) {
        if (rate instanceof InstantlyNode) {
            return new InstantlyRate();
        }
        if (rate instanceof AgeRateNode) {
            return new AgeRate(((AgeRateNode)rate).getAge());
        }
        if (rate instanceof RateExpressionNode) {
            IExpression expression = ((RateExpressionNode)rate).getExpression();
            if (this.tdv.isTimeDependent(expression, model)) {
                return new PiecewiseConstantRate(expression);
            }
            return new TimeIndependentRate(expression);
        }
        if (rate instanceof EveryRateNode) {
            return new EveryRate(((EveryRateNode)rate).getInterval());
        }
        if (rate instanceof EverySynchronizedRateNode) {
            return new EverySynchronizedRate(((EverySynchronizedRateNode)rate).getInterval());
        }
        return null;
    }

    private AttributeDeclaration build(AttributeDeclarationNode attributeDeclaration) {
        String name = attributeDeclaration.getName();
        IType type = attributeDeclaration.getType();
        if (attributeDeclaration.getDefaultValue() != null) {
            IValue defaultValue = attributeDeclaration.getDefaultValue();
            return new AttributeDeclaration(name, type, defaultValue);
        }
        return new AttributeDeclaration(name, type);
    }

    private IExpression andMergeExpressions(List<IExpression> expressions) {
        if (expressions.size() == 0) {
            return new ConstExpression(null, BoolValue.TRUE);
        }
        AndExpression and = new AndExpression(null);
        and.setLeftExpression(expressions.get(0));
        and.setRightExpression(this.andMergeExpressions(expressions.subList(1, expressions.size())));
        return and;
    }

    private Pair<IExpression, IExpression> andMergeWithRateExpression(List<IExpression> expressions, IExpression rateExpression, Model model) {
        if (expressions.size() == 0) {
            return new Pair<IExpression, IExpression>(new ConstExpression(null, BoolValue.TRUE), rateExpression);
        }
        ConditionalExpression newRateExpression = null;
        if (this.tdv.isTimeDependent(expressions.get(0), model)) {
            newRateExpression = new ConditionalExpression(null);
            newRateExpression.setCondition(expressions.get(0));
            newRateExpression.setThenExpression(rateExpression);
            newRateExpression.setElseExpression(new ConstExpression(null, new RealValue(0.0)));
            return this.andMergeWithRateExpression(expressions.subList(1, expressions.size()), newRateExpression, model);
        }
        AndExpression and = new AndExpression(null);
        and.setLeftExpression(expressions.get(0));
        Pair<IExpression, IExpression> pair = this.andMergeWithRateExpression(expressions.subList(1, expressions.size()), rateExpression, model);
        and.setRightExpression(pair.getFirst());
        return new Pair<IExpression, IExpression>(and, pair.getSecond());
    }

    private class Pair<L, R> {
        private L l;
        private R r;

        public Pair(L l, R r) {
            this.l = l;
            this.r = r;
        }

        public L getFirst() {
            return this.l;
        }

        public R getSecond() {
            return this.r;
        }
    }
}

