/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.model.agents;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jamesii.ml3.model.agents.AgentDeclaration;
import org.jamesii.ml3.model.agents.AttributeDeclaration;
import org.jamesii.ml3.model.agents.IAgent;
import org.jamesii.ml3.model.agents.IAgentFactory;
import org.jamesii.ml3.model.agents.LinkDeclaration;
import org.jamesii.ml3.model.types.BasicType;
import org.jamesii.ml3.model.values.AgentValue;
import org.jamesii.ml3.model.values.BoolValue;
import org.jamesii.ml3.model.values.INumericalValue;
import org.jamesii.ml3.model.values.IValue;
import org.jamesii.ml3.model.values.IntValue;
import org.jamesii.ml3.model.values.RealValue;
import org.jamesii.ml3.model.values.SetValue;
import org.jamesii.ml3.model.values.StringValue;
import org.jamesii.ml3.simulator.exceptions.SimulationException;

public abstract class AbstractAgentFactory
implements IAgentFactory {
    private int lastID = -1;

    private int newID() {
        ++this.lastID;
        return this.lastID;
    }

    @Override
    public IAgent createAgent(AgentDeclaration agentType, double timeOfBirth) {
        return this.createAgentWithID(this.newID(), agentType, timeOfBirth, Collections.emptyMap());
    }

    @Override
    public IAgent createAgent(AgentDeclaration agentType, double timeOfBirth, Map<String, IValue> fields) {
        return this.createAgentWithID(this.newID(), agentType, timeOfBirth, fields);
    }

    @Override
    public IAgent createAgentWithID(int id, AgentDeclaration agentType, double timeOfBirth) {
        return this.createAgentWithID(id, agentType, timeOfBirth, Collections.emptyMap());
    }

    @Override
    public IAgent createAgentFromStrings(AgentDeclaration agentType, double timeOfBirth, Map<String, String> stringFields) {
        return this.createAgentWithIDFromStrings(this.newID(), agentType, timeOfBirth, stringFields);
    }

    @Override
    public IAgent createAgentWithIDFromStrings(int id, AgentDeclaration agentType, double timeOfBirth, Map<String, String> stringFields) {
        HashMap<String, IValue> fields = new HashMap<String, IValue>();
        for (String attribute : stringFields.keySet()) {
            AttributeDeclaration ad = agentType.getAttribute(attribute);
            if (ad == null) {
                throw new SimulationException("Tried to initialize not existing attribute (" + attribute + " of " + agentType.getName() + ")");
            }
            String stringValue = stringFields.get(attribute);
            IValue value = ad.getType().equals(BasicType.BOOL) ? new BoolValue(stringValue) : (ad.getType().equals(BasicType.INT) ? new IntValue(stringValue) : (ad.getType().equals(BasicType.REAL) ? new RealValue(stringValue) : new StringValue(stringValue)));
            fields.put(attribute, value);
        }
        return this.createAgentWithID(id, agentType, timeOfBirth, fields);
    }

    protected double extractInitialAge(Map<String, IValue> fields) {
        double initialAge = 0.0;
        if (fields.containsKey("age")) {
            initialAge = ((INumericalValue)fields.get("age")).getDouble();
        }
        return initialAge;
    }

    protected Map<String, IValue> extractAttributeValues(Map<String, IValue> fields, AgentDeclaration agentType) {
        HashMap<String, IValue> attributes = new HashMap<String, IValue>();
        for (AttributeDeclaration attributeDeclaration : agentType.getAttributes()) {
            String name = attributeDeclaration.getName();
            IValue value = fields.containsKey(name) ? fields.get(name) : attributeDeclaration.getDefault();
            attributes.put(name, value);
        }
        return attributes;
    }

    protected Map<String, Set<IAgent>> extractLinkPartners(Map<String, IValue> fields, AgentDeclaration agentType) {
        HashMap<String, Set<IAgent>> links = new HashMap<String, Set<IAgent>>();
        for (LinkDeclaration linkDeclaration : agentType.getLinks()) {
            String name = linkDeclaration.getPartnerRole();
            SetValue value = fields.containsKey(name) ? (SetValue)fields.get(name) : new SetValue();
            HashSet<IAgent> set = new HashSet<IAgent>();
            Iterator iterator = value.getValue().iterator();
            while (iterator.hasNext()) {
                IValue v = (IValue)iterator.next();
                AgentValue av = (AgentValue)v;
                set.add(av.getValue());
            }
            links.put(name, set);
        }
        return links;
    }
}

