/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.model;

import java.util.HashMap;
import java.util.Map;
import org.jamesii.ml3.model.maps.IValueMap;
import org.jamesii.ml3.model.values.IValue;
import org.jamesii.ml3.model.values.RealValue;

public class Parameters {
    private static final String E = "e";
    private static final String PI = "pi";
    private Map<String, IValue> constants = new HashMap<String, IValue>();
    private Map<String, IValueMap> maps = new HashMap<String, IValueMap>();

    public Parameters() {
        this.constants.put(E, new RealValue(Math.E));
        this.constants.put(PI, new RealValue(Math.PI));
    }

    public void add(String name, IValue value) {
        this.constants.put(name, value);
    }

    public void add(String name, IValueMap map) {
        this.maps.put(name, map);
    }

    public IValue getValue(String name) {
        IValue v = this.constants.get(name);
        if (v != null) {
            return v;
        }
        throw new RuntimeException("Parameter " + name + " does not exist.");
    }

    public IValueMap getValueMap(String name) {
        IValueMap map = this.maps.get(name);
        if (map != null) {
            return map;
        }
        throw new RuntimeException("Parameter " + name + " does not exist.");
    }

    public boolean isConstant(String name) {
        return this.constants.containsKey(name);
    }

    public boolean isMap(String name) {
        return this.maps.containsKey(name);
    }
}

