/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.misc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import org.jamesii.core.util.misc.Pair;

public class CSVWriter {
    private static final String DELIMITER = ", ";
    private PrintStream out;

    public CSVWriter(String path) {
        if (path.equals("System.out")) {
            this.out = System.out;
        } else {
            try {
                this.out = new PrintStream(new File(path));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public <A, B> void write(Pair<A, B> p) {
        this.out.println(p.getFirstValue() + DELIMITER + p.getSecondValue());
    }

    @SafeVarargs
    public final <A> void write(A ... objects) {
        String line = "";
        if (objects.length > 0) {
            line = line + objects[0].toString();
            for (int i = 1; i < objects.length; ++i) {
                line = line + DELIMITER + objects[i].toString();
            }
        }
        this.out.println(line);
    }

    public <A> void write(Collection<A> objects) {
        String line = "";
        if (objects.size() > 0) {
            Iterator<A> iterator = objects.iterator();
            line = line + iterator.next().toString();
            while (iterator.hasNext()) {
                line = line + DELIMITER + iterator.next().toString();
            }
        }
        this.out.println(line);
    }

    public void flush() {
        this.out.flush();
    }

    public void finish() {
        if (this.out != System.out) {
            this.out.flush();
            this.out.close();
        }
    }
}

