/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.experiment.thread;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jamesii.ml3.experiment.thread.IThrowingRunnable;

public class ThrowableAwareExecutor
extends ThreadPoolExecutor {
    private final boolean stopOnError;

    public ThrowableAwareExecutor(int cores, boolean stopOnError) {
        super(cores, cores, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.stopOnError = stopOnError;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        if (t != null) {
            if (this.stopOnError) {
                this.shutdownNow();
            }
            if (!(r instanceof IThrowingRunnable)) throw new IllegalStateException("Thread threw an exception:\n", t);
            ((IThrowingRunnable)r).onException(t);
            return;
        } else {
            if (!(r instanceof IThrowingRunnable)) return;
            ((IThrowingRunnable)r).onFinish();
        }
    }
}

