/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.experiment.init;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import org.apache.commons.math3.random.RandomGenerator;
import org.jamesii.ml3.experiment.init.IInitialStateBuilder;
import org.jamesii.ml3.model.Model;
import org.jamesii.ml3.model.Parameters;
import org.jamesii.ml3.model.agents.AgentDeclaration;
import org.jamesii.ml3.model.agents.AttributeDeclaration;
import org.jamesii.ml3.model.agents.IAgent;
import org.jamesii.ml3.model.agents.IAgentFactory;
import org.jamesii.ml3.model.agents.LinkDeclaration;
import org.jamesii.ml3.model.state.IState;
import org.jamesii.ml3.model.state.IStateFactory;
import org.jamesii.ml3.model.state.writers.JsonStateWriter;
import org.jamesii.ml3.model.types.BasicType;
import org.jamesii.ml3.model.values.BoolValue;
import org.jamesii.ml3.model.values.IValue;
import org.jamesii.ml3.model.values.IntValue;
import org.jamesii.ml3.model.values.RealValue;
import org.jamesii.ml3.model.values.StringValue;

public class JsonStateBuilder
implements IInitialStateBuilder {
    private File file;
    private JsonObject jsonState;

    public JsonStateBuilder(String path) {
        this.file = new File(path);
    }

    public JsonStateBuilder(File file) {
        this.file = file;
    }

    @Override
    public IState buildInitialState(Model model, IStateFactory stateFactory, IAgentFactory agentFactory, RandomGenerator rng, Parameters parameters) {
        JsonObject jsonAgent;
        if (this.jsonState == null) {
            try {
                this.jsonState = new JsonParser().parse((Reader)new FileReader(this.file)).getAsJsonObject();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        IState state = stateFactory.create();
        JsonArray jsonAgents = this.jsonState.get("agents").getAsJsonArray();
        for (JsonElement jsonElement : jsonAgents) {
            jsonAgent = (JsonObject)jsonElement;
            state.addAgent(this.readAgentWithoutLinks(jsonAgent, agentFactory, model));
        }
        for (JsonElement jsonElement : jsonAgents) {
            jsonAgent = (JsonObject)jsonElement;
            this.establishLinks(state, jsonAgent, model);
        }
        return state;
    }

    private IAgent readAgentWithoutLinks(JsonObject jsonAgent, IAgentFactory af, Model model) {
        int id = jsonAgent.get("id").getAsInt();
        String type = jsonAgent.get("type").getAsString();
        boolean alive = jsonAgent.get("alive").getAsBoolean();
        double birth = jsonAgent.get("birth").getAsDouble();
        double death = jsonAgent.get("death").getAsDouble();
        AgentDeclaration agentDeclaration = model.getAgentDeclaration(type);
        IAgent agent = af.createAgentWithID(id, agentDeclaration, birth);
        if (!alive) {
            agent.die(death);
        }
        for (AttributeDeclaration ad : agentDeclaration.getAttributes()) {
            String key = ad.getName();
            IValue value = ad.getType().equals(BasicType.BOOL) ? new BoolValue(jsonAgent.get(JsonStateWriter.getJsonAttributeName(key)).getAsBoolean()) : (ad.getType().equals(BasicType.INT) ? new IntValue(jsonAgent.get(JsonStateWriter.getJsonAttributeName(key)).getAsInt()) : (ad.getType().equals(BasicType.REAL) ? new RealValue(jsonAgent.get(JsonStateWriter.getJsonAttributeName(key)).getAsDouble()) : new StringValue(jsonAgent.get(JsonStateWriter.getJsonAttributeName(key)).getAsString())));
            agent.setAttributeValue(key, value);
        }
        return agent;
    }

    private void establishLinks(IState state, JsonObject jsonAgent, Model model) {
        int id = jsonAgent.get("id").getAsInt();
        String type = jsonAgent.get("type").getAsString();
        AgentDeclaration agentDeclaration = model.getAgentDeclaration(type);
        IAgent agent = state.getAgent(id);
        for (LinkDeclaration ld : agentDeclaration.getLinks()) {
            String partnerRole = ld.getPartnerRole();
            JsonArray jsonArray = jsonAgent.get(JsonStateWriter.getJsonLinkName(partnerRole)).getAsJsonArray();
            for (JsonElement partnerElement : jsonArray) {
                int partnerId = partnerElement.getAsInt();
                IAgent partnerAgent = state.getAgent(partnerId);
                agent.addLink(partnerRole, partnerAgent);
            }
        }
    }
}

