/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.experiment;

import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomGenerator;
import org.jamesii.ml3.experiment.Job;
import org.jamesii.ml3.experiment.init.IInitialStateBuilder;
import org.jamesii.ml3.experiment.thread.IThrowingRunnable;
import org.jamesii.ml3.model.Model;
import org.jamesii.ml3.model.Parameters;
import org.jamesii.ml3.model.agents.IAgentFactory;
import org.jamesii.ml3.model.state.IState;
import org.jamesii.ml3.model.state.SimpleStateFactory;
import org.jamesii.ml3.simulator.factory.ISimulatorFactory;
import org.jamesii.ml3.simulator.simulators.ISimulator;
import org.jamesii.ml3.simulator.stop.IStopCondition;

class SimulationRun
implements IThrowingRunnable {
    private final Model model;
    private final Job job;
    private final IStopCondition stopCondition;
    private final IInitialStateBuilder initialStateBuilder;
    private final ISimulatorFactory simulatorFactory;
    private final Double startTime;

    SimulationRun(Model model, Job job, IStopCondition stopCondition, IInitialStateBuilder initialStateBuilder, ISimulatorFactory simulatorFactory, Double startTime) {
        this.model = model;
        this.job = job;
        this.stopCondition = stopCondition;
        this.initialStateBuilder = initialStateBuilder;
        this.simulatorFactory = simulatorFactory;
        this.startTime = startTime;
    }

    @Override
    public void run() {
        IAgentFactory agentFactory = this.simulatorFactory.createAgentFactory();
        SimpleStateFactory stateFactory = new SimpleStateFactory(agentFactory);
        MersenneTwister rng = new MersenneTwister(System.currentTimeMillis());
        Parameters parameters = this.job.getParameters();
        IState initialState = this.initialStateBuilder.buildInitialState(this.model, stateFactory, agentFactory, (RandomGenerator)rng, parameters);
        ISimulator simulator = this.simulatorFactory.createSimulator(this.model, agentFactory, (RandomGenerator)rng, parameters);
        this.job.instrument(simulator);
        simulator.run(initialState, this.startTime, this.stopCondition);
    }

    @Override
    public void onFinish() {
        this.job.onSuccess();
    }

    @Override
    public void onException(Throwable t) {
        this.job.onFailure(t);
    }
}

