/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.experiment;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.jamesii.ml3.experiment.Job;
import org.jamesii.ml3.experiment.SimulationRun;
import org.jamesii.ml3.experiment.init.IInitialStateBuilder;
import org.jamesii.ml3.experiment.thread.ThrowableAwareExecutor;
import org.jamesii.ml3.model.Model;
import org.jamesii.ml3.model.build.ModelBuilder;
import org.jamesii.ml3.parser.ParserUtil;
import org.jamesii.ml3.parser.nodes.ModelNode;
import org.jamesii.ml3.simulator.factory.ISimulatorFactory;
import org.jamesii.ml3.simulator.stop.IStopCondition;

public class Experiment {
    private final ExecutorService executorService;
    final Model model;
    private final IStopCondition stopCondition;
    private final IInitialStateBuilder initialStateBuilder;
    private final ISimulatorFactory simulatorFactory;
    private final Double startTime;

    public Experiment(String modelFileLocation, int cores, IStopCondition stopCondition, IInitialStateBuilder initialStateBuilder, ISimulatorFactory simulatorFactory, Double startTime) throws IOException {
        this.model = this.parseModel(modelFileLocation);
        this.executorService = new ThrowableAwareExecutor(cores, true);
        this.stopCondition = stopCondition;
        this.initialStateBuilder = initialStateBuilder;
        this.simulatorFactory = simulatorFactory;
        this.startTime = startTime;
    }

    private Model parseModel(String modelFileLocation) throws IOException {
        ModelNode t = ParserUtil.parseFile(modelFileLocation);
        ModelBuilder mb = new ModelBuilder();
        return mb.build(t);
    }

    public boolean addJob(Job job) {
        try {
            SimulationRun simulationRun = new SimulationRun(this.model, job, this.stopCondition, this.initialStateBuilder, this.simulatorFactory, this.startTime);
            this.executorService.execute(simulationRun);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void finish() {
        this.executorService.shutdown();
    }

    public boolean awaitTermination(long millis) throws InterruptedException {
        return this.executorService.awaitTermination(millis, TimeUnit.MILLISECONDS);
    }
}

