/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.core.util.eventset.calendar;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jamesii.core.util.eventset.Entry;
import org.jamesii.core.util.eventset.calendar.CalendarQueue;

public class CalendarReQueue<M>
extends CalendarQueue<M> {
    private static final long serialVersionUID = 7958295673185185226L;
    private Map<M, Double> events = new IdentityHashMap<M, Double>();

    public CalendarReQueue() {
    }

    public CalendarReQueue(int initialSize) {
        super(initialSize);
    }

    @Override
    public Entry<M, Double> dequeue() {
        Entry result = super.dequeue();
        if (result != null) {
            this.events.remove(result.getEvent());
        }
        return result;
    }

    @Override
    public Double dequeue(M event) {
        Double t = this.events.remove(event);
        if (t != null) {
            this.dequeue(event, t);
        }
        return t;
    }

    @Override
    public ArrayList<M> dequeueAll() {
        List result = super.dequeueAll();
        for (Object e : result) {
            this.events.remove(e);
        }
        return result;
    }

    @Override
    public List<M> dequeueAll(Double time) {
        List result = super.dequeueAll(time);
        for (Object e : result) {
            this.events.remove(e);
        }
        return result;
    }

    @Override
    public Map<M, Object> dequeueAllHashed() {
        Map result = super.dequeueAllHashed();
        for (Object e : result.keySet()) {
            this.events.remove(e);
        }
        return result;
    }

    @Override
    public void enqueue(M event, Double priority) {
        super.enqueue(event, priority);
        this.events.put(event, priority);
    }

    @Override
    public Double getTime(M event) {
        return this.events.get(event);
    }

    @Override
    public void requeue(M event, Double newTime) {
        Double oldTime = this.events.get(event);
        super.requeue(event, oldTime, newTime);
    }
}

