/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.core.util.eventset;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jamesii.core.util.eventset.AbstractCollectionEventQueue;
import org.jamesii.core.util.eventset.Entry;

public class UnsortedListEventQueue<E, T extends Comparable<T>>
extends AbstractCollectionEventQueue<E, T, List<Entry<E, T>>> {
    private static final long serialVersionUID = -5032833053356766973L;

    public UnsortedListEventQueue() {
        super(new ArrayList());
    }

    @Override
    public Entry<E, T> dequeue() {
        if (this.isEmpty()) {
            return null;
        }
        Entry min = (Entry)((List)this.getData()).get(0);
        int minIndex = 0;
        for (int i = 1; i < ((List)this.getData()).size(); ++i) {
            if (min.getTime().compareTo(((Entry)((List)this.getData()).get(i)).getTime()) <= 0) continue;
            min = (Entry)((List)this.getData()).get(i);
            minIndex = i;
        }
        ((List)this.getData()).remove(minIndex);
        return min;
    }

    @Override
    public T dequeue(E event) {
        int index = -1;
        for (int i = 0; i < ((List)this.getData()).size(); ++i) {
            if (((Entry)((List)this.getData()).get(i)).getEvent() != event) continue;
            index = i;
            break;
        }
        if (index != -1) {
            Object result = ((Entry)((List)this.getData()).get(index)).getTime();
            ((List)this.getData()).remove(index);
            return result;
        }
        return null;
    }

    @Override
    public List<E> dequeueAll() {
        int i;
        ArrayList result = new ArrayList();
        if (this.isEmpty()) {
            return result;
        }
        Entry min = (Entry)((List)this.getData()).get(0);
        result.add(min.getEvent());
        ArrayList<Integer> minIndex = new ArrayList<Integer>();
        minIndex.add(0);
        for (i = 1; i < ((List)this.getData()).size(); ++i) {
            int comp = min.getTime().compareTo(((Entry)((List)this.getData()).get(i)).getTime());
            if (comp > 0) {
                result.clear();
                minIndex.clear();
                min = (Entry)((List)this.getData()).get(i);
                result.add(min.getEvent());
                minIndex.add(i);
                continue;
            }
            if (comp != 0) continue;
            result.add(((Entry)((List)this.getData()).get(i)).getEvent());
            minIndex.add(i);
        }
        for (i = minIndex.size() - 1; i >= 0; --i) {
            ((List)this.getData()).remove((Integer)minIndex.get(i));
        }
        return result;
    }

    @Override
    public List<E> dequeueAll(T time) {
        int i;
        ArrayList result = new ArrayList();
        if (this.isEmpty()) {
            return result;
        }
        ArrayList<Integer> minIndex = new ArrayList<Integer>();
        for (i = 0; i < ((List)this.getData()).size(); ++i) {
            int comp = time.compareTo(((Entry)((List)this.getData()).get(i)).getTime());
            if (comp != 0) continue;
            result.add(((Entry)((List)this.getData()).get(i)).getEvent());
            minIndex.add(i);
        }
        for (i = minIndex.size() - 1; i >= 0; --i) {
            ((List)this.getData()).remove((Integer)minIndex.get(i));
        }
        return result;
    }

    @Override
    public Map<E, Object> dequeueAllHashed() {
        int i;
        HashMap result = new HashMap();
        if (this.isEmpty()) {
            return result;
        }
        Entry min = (Entry)((List)this.getData()).get(0);
        result.put(min.getEvent(), null);
        ArrayList<Integer> minIndex = new ArrayList<Integer>();
        minIndex.add(0);
        for (i = 1; i < ((List)this.getData()).size(); ++i) {
            int comp = min.getTime().compareTo(((Entry)((List)this.getData()).get(i)).getTime());
            if (comp > 0) {
                result.clear();
                minIndex.clear();
                min = (Entry)((List)this.getData()).get(i);
                result.put(min.getEvent(), null);
                minIndex.add(i);
                continue;
            }
            if (comp != 0) continue;
            result.put(((Entry)((List)this.getData()).get(i)).getEvent(), null);
            minIndex.add(i);
        }
        for (i = minIndex.size() - 1; i >= 0; --i) {
            ((List)this.getData()).remove((Integer)minIndex.get(i));
        }
        return result;
    }

    @Override
    public T getMin() {
        if (this.isEmpty()) {
            return null;
        }
        Entry min = (Entry)((List)this.getData()).get(0);
        for (int i = 1; i < ((List)this.getData()).size(); ++i) {
            if (min.getTime().compareTo(((Entry)((List)this.getData()).get(i)).getTime()) <= 0) continue;
            min = (Entry)((List)this.getData()).get(i);
        }
        return min.getTime();
    }

    @Override
    public T getTime(E event) {
        int index = -1;
        for (int i = 0; i < ((List)this.getData()).size(); ++i) {
            if (((Entry)((List)this.getData()).get(i)).getEvent() != event) continue;
            index = i;
            break;
        }
        if (index != -1) {
            return ((Entry)((List)this.getData()).get(index)).getTime();
        }
        return null;
    }
}

