/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.core.util.eventset;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jamesii.core.util.eventset.BasicHashedBucketsEventQueue;
import org.jamesii.core.util.eventset.Entry;

public class TwoListWithBucketsSimpleThreshold<E>
extends BasicHashedBucketsEventQueue<E> {
    static final long serialVersionUID = 694024363454798118L;
    private Map<Double, Map<E, Object>> nearFuture = new HashMap<Double, Map<E, Object>>();
    private Map<E, Double> farFuture = new HashMap<E, Double>();
    private double maxbuckettime = 0.0;
    private int threshold = 8;
    private int size = 0;

    public TwoListWithBucketsSimpleThreshold() {
    }

    public TwoListWithBucketsSimpleThreshold(Integer thresh) {
        this.threshold = thresh;
    }

    private void reorganize() {
        Double min = Double.POSITIVE_INFINITY;
        HashMap toCopy = new HashMap();
        if (this.farFuture.isEmpty()) {
            return;
        }
        for (Map.Entry<E, Double> entry : this.farFuture.entrySet()) {
            int c = min.compareTo(entry.getValue());
            if (c > 0) {
                min = entry.getValue();
                toCopy.clear();
                toCopy.put(entry.getKey(), null);
                continue;
            }
            if (c != 0) continue;
            toCopy.put(entry.getKey(), null);
        }
        this.maxbuckettime = min;
        for (Map.Entry<Object, Double> e : toCopy.keySet()) {
            this.farFuture.remove(e);
        }
        this.nearFuture.put(min, toCopy);
    }

    private Double minInBuckets() {
        Double d = null;
        for (Map.Entry<Double, Map<E, Object>> entry : this.nearFuture.entrySet()) {
            if (d == null) {
                d = entry.getKey();
                continue;
            }
            if (d.compareTo(entry.getKey()) <= 0) continue;
            d = entry.getKey();
        }
        return d;
    }

    @Override
    public Entry<E, Double> dequeue() {
        Map<E, Object> l;
        Iterator<E> it;
        Double d = this.minInBuckets();
        if (d == null) {
            this.reorganize();
            d = this.minInBuckets();
            if (d == null) {
                return null;
            }
        }
        if ((it = (l = this.nearFuture.get(d)).keySet().iterator()).hasNext()) {
            E e = it.next();
            it.remove();
            --this.size;
            if (!it.hasNext()) {
                this.nearFuture.remove(d);
            }
            return new Entry<E, Double>(e, d);
        }
        return null;
    }

    @Override
    public Double dequeue(E event) {
        Double d = this.farFuture.remove(event);
        if (d == null) {
            Map.Entry<Double, Map<E, Object>> found = null;
            for (Map.Entry<Double, Map<E, Object>> list : this.nearFuture.entrySet()) {
                if (!list.getValue().containsKey(event)) continue;
                found = list;
                break;
            }
            if (found != null) {
                ((Map)found.getValue()).remove(event);
                d = (Double)found.getKey();
                if (found.getValue().isEmpty()) {
                    this.nearFuture.remove(d);
                }
            }
        }
        if (d != null) {
            --this.size;
        }
        return d;
    }

    @Override
    public List<E> dequeueAll() {
        List<E> result = this.dequeueAll(this.getMin());
        return result;
    }

    @Override
    public List<E> dequeueAll(Double time) {
        ArrayList<E> result;
        Map<E, Object> collection = this.nearFuture.remove(time);
        if (collection == null) {
            result = new ArrayList<E>();
            Iterator<Map.Entry<E, Double>> it = this.farFuture.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<E, Double> e = it.next();
                if (e.getValue().compareTo(time) != 0) continue;
                result.add(e.getKey());
                it.remove();
            }
        } else {
            result = new ArrayList<E>(collection.keySet());
        }
        this.size -= result.size();
        return result;
    }

    @Override
    public Map<E, Object> dequeueAllHashed() {
        return this.dequeueAllHashed(this.getMin());
    }

    public Map<E, Object> dequeueAllHashed(Double time) {
        Map<E, Object> result = this.nearFuture.remove(time);
        if (result == null) {
            List<E> list = this.dequeueAll(time);
            result = new HashMap<E, Object>();
            for (E e : list) {
                result.put(e, null);
            }
        } else {
            this.size -= result.size();
        }
        return result;
    }

    @Override
    public void enqueue(E event, Double time) {
        if (time != Double.POSITIVE_INFINITY && time.compareTo(this.maxbuckettime) <= 0) {
            if (this.hasBucket(time, this.nearFuture)) {
                this.putInList(this.nearFuture, time, event);
                ++this.size;
                return;
            }
            if (this.nearFuture.size() < this.threshold) {
                this.putInList(this.nearFuture, time, event);
                ++this.size;
                return;
            }
            Double max = this.findMax(this.nearFuture);
            if (time.compareTo(max) > 0) {
                this.maxbuckettime = max;
            } else {
                Map<E, Object> mod = this.nearFuture.get(max);
                for (E e : mod.keySet()) {
                    this.farFuture.put(e, max);
                }
                this.nearFuture.remove(max);
                mod = new HashMap<E, Object>();
                mod.put(event, null);
                this.nearFuture.put(time, mod);
                this.maxbuckettime = this.findMax(this.nearFuture);
                ++this.size;
                return;
            }
        }
        if (this.farFuture.put(event, time) == null) {
            ++this.size;
        }
    }

    @Override
    public Double getMin() {
        Double min = this.minInBuckets();
        if (min != null) {
            return min;
        }
        if (this.farFuture.isEmpty()) {
            return null;
        }
        min = Double.POSITIVE_INFINITY;
        for (E m : this.farFuture.keySet()) {
            Double time = this.farFuture.get(m);
            if (Double.compare(time, min) >= 0) continue;
            min = time;
        }
        return min;
    }

    @Override
    public Double getTime(E event) {
        Double d = this.farFuture.get(event);
        if (d == null) {
            for (Map.Entry<Double, Map<E, Object>> list : this.nearFuture.entrySet()) {
                if (!list.getValue().containsKey(event)) continue;
                return list.getKey();
            }
        }
        return d;
    }

    @Override
    public boolean isEmpty() {
        return this.farFuture.isEmpty();
    }

    private void shift(Double[] arr) {
        System.arraycopy(arr, 0, arr, 1, arr.length - 1);
    }

    @Override
    public int size() {
        return this.size;
    }
}

