/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.core.util.eventset;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jamesii.core.util.eventset.AbstractCollectionEventQueue;
import org.jamesii.core.util.eventset.Entry;

public class TreeSetEventQueue<E, T extends Comparable<T>>
extends AbstractCollectionEventQueue<E, T, SortedSet<Entry<E, T>>> {
    private static final long serialVersionUID = 449964186107779822L;

    public TreeSetEventQueue() {
        super(new TreeSet());
    }

    private Entry<E, T> extractTop() {
        Entry result = (Entry)((SortedSet)this.getData()).first();
        Iterator it = ((SortedSet)this.getData()).iterator();
        it.next();
        it.remove();
        return result;
    }

    @Override
    public Entry<E, T> dequeue() {
        if (this.isEmpty()) {
            return null;
        }
        return this.extractTop();
    }

    @Override
    public List<E> dequeueAll() {
        ArrayList result = new ArrayList();
        if (this.isEmpty()) {
            return result;
        }
        Entry min = (Entry)((SortedSet)this.getData()).first();
        result.add(min.getEvent());
        Iterator it = ((SortedSet)this.getData()).iterator();
        it.next();
        it.remove();
        while (it.hasNext()) {
            Entry cur = (Entry)it.next();
            if (min.getTime().compareTo(cur.getTime()) != 0) break;
            it.remove();
            result.add(cur.getEvent());
        }
        return result;
    }

    @Override
    public List<E> dequeueAll(T time) {
        ArrayList result = new ArrayList();
        if (this.isEmpty()) {
            return result;
        }
        boolean first = false;
        Entry entry = null;
        Iterator eIt = ((SortedSet)this.getData()).iterator();
        while (eIt.hasNext()) {
            entry = (Entry)eIt.next();
            if (entry.getTime().compareTo(time) != 0) continue;
            first = true;
            result.add(entry.getEvent());
            eIt.remove();
            break;
        }
        if (!first) {
            return result;
        }
        while (eIt.hasNext()) {
            entry = (Entry)eIt.next();
            if (entry.getTime().compareTo(time) != 0) continue;
            result.add(entry.getEvent());
            eIt.remove();
        }
        return result;
    }

    @Override
    public Map<E, Object> dequeueAllHashed() {
        HashMap result = new HashMap();
        if (this.isEmpty()) {
            return result;
        }
        Entry min = (Entry)((SortedSet)this.getData()).first();
        result.put(min.getEvent(), null);
        Iterator it = ((SortedSet)this.getData()).iterator();
        it.next();
        it.remove();
        while (it.hasNext()) {
            Entry cur = (Entry)it.next();
            if (min.getTime().compareTo(cur.getTime()) != 0) break;
            it.remove();
            result.put(cur.getEvent(), null);
        }
        return result;
    }

    @Override
    public T getMin() {
        if (this.isEmpty()) {
            return null;
        }
        return ((Entry)((SortedSet)this.getData()).first()).getTime();
    }
}

