/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.core.util.eventset;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jamesii.core.util.eventset.AbstractEventQueue;
import org.jamesii.core.util.eventset.Entry;

public class SimpleEventQueue<E, T extends Comparable<T>>
extends AbstractEventQueue<E, T> {
    static final long serialVersionUID = -7714447518255735315L;
    private Map<E, T> events = new HashMap<E, T>();

    @Override
    public Entry<E, T> dequeue() {
        Map.Entry<E, T> e;
        Comparable minValue = null;
        Entry<E, Comparable> ent = null;
        Entry<E, Comparable> entF = null;
        Iterator<Map.Entry<E, T>> eIt = this.events.entrySet().iterator();
        Boolean first = null;
        if (eIt.hasNext()) {
            first = true;
            e = eIt.next();
            minValue = (Comparable)e.getValue();
            entF = new Entry<E, Comparable>(e.getKey(), (Comparable)e.getValue());
        }
        if (first == null) {
            return null;
        }
        while (eIt.hasNext()) {
            e = eIt.next();
            if (((Comparable)e.getValue()).compareTo(minValue) > 0) continue;
            first = false;
            minValue = (Comparable)e.getValue();
            ent = new Entry<E, Comparable>(e.getKey(), (Comparable)e.getValue());
        }
        if (ent != null) {
            this.events.remove(ent.getEvent());
            return ent;
        }
        if (first.booleanValue()) {
            this.events.remove(entF.getEvent());
            return entF;
        }
        return null;
    }

    @Override
    public T dequeue(E event) {
        Comparable result = (Comparable)this.events.get(event);
        this.events.remove(event);
        return (T)result;
    }

    @Override
    public List<E> dequeueAll() {
        return this.dequeueAll(this.getMin());
    }

    @Override
    public List<E> dequeueAll(T time) {
        ArrayList<E> result = new ArrayList<E>();
        for (E m : this.events.keySet()) {
            if (((Comparable)this.events.get(m)).compareTo(time) != 0) continue;
            result.add(m);
        }
        for (int i = 0; i < result.size(); ++i) {
            this.events.remove(result.get(i));
        }
        return result;
    }

    @Override
    public Map<E, Object> dequeueAllHashed() {
        return this.dequeueAllHashed(this.getMin());
    }

    public Map<E, Object> dequeueAllHashed(T time) {
        HashMap result = new HashMap();
        for (Object m : this.events.keySet()) {
            if (((Comparable)this.events.get(m)).compareTo(time) != 0) continue;
            result.put(m, null);
        }
        for (Object m : result.keySet()) {
            this.events.remove(m);
        }
        return result;
    }

    @Override
    public void enqueue(E event, T time) {
        this.events.put(event, time);
    }

    @Override
    public T getMin() {
        if (this.size() == 0) {
            return null;
        }
        Iterator<T> vIt = this.events.values().iterator();
        Comparable tonie = (Comparable)vIt.next();
        while (vIt.hasNext()) {
            Comparable d = (Comparable)vIt.next();
            if (d.compareTo(tonie) >= 0) continue;
            tonie = d;
        }
        return (T)tonie;
    }

    @Override
    public T getTime(E event) {
        return (T)((Comparable)this.events.get(event));
    }

    @Override
    public boolean isEmpty() {
        return this.events.isEmpty();
    }

    @Override
    public void requeue(E event, T time) {
        this.events.put(event, time);
    }

    @Override
    public void requeue(E event, T oldTime, T time) {
        this.dequeue(event);
        this.enqueue(event, time);
    }

    @Override
    public int size() {
        return this.events.size();
    }
}

