/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.core.util.eventset;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.jamesii.core.util.eventset.AbstractCollectionEventQueue;
import org.jamesii.core.util.eventset.Entry;

public class PriorityQueueEventQueue<E, T extends Comparable<T>>
extends AbstractCollectionEventQueue<E, T, PriorityQueue<Entry<E, T>>> {
    private static final long serialVersionUID = 449964186107779822L;

    public PriorityQueueEventQueue() {
        super(new PriorityQueue());
    }

    @Override
    public Entry<E, T> dequeue() {
        return (Entry)((PriorityQueue)this.getData()).poll();
    }

    @Override
    public List<E> dequeueAll() {
        ArrayList result = new ArrayList();
        if (this.isEmpty()) {
            return result;
        }
        Entry min = (Entry)((PriorityQueue)this.getData()).poll();
        result.add(min.getEvent());
        while (((PriorityQueue)this.getData()).size() > 0 && min.getTime().compareTo(((Entry)((PriorityQueue)this.getData()).peek()).getTime()) == 0) {
            result.add(((Entry)((PriorityQueue)this.getData()).poll()).getEvent());
        }
        return result;
    }

    @Override
    public List<E> dequeueAll(T time) {
        ArrayList result = new ArrayList();
        if (this.isEmpty()) {
            return result;
        }
        boolean first = false;
        Entry entry = null;
        Iterator eIt = ((PriorityQueue)this.getData()).iterator();
        while (eIt.hasNext()) {
            entry = (Entry)eIt.next();
            if (entry.getTime().compareTo(time) != 0) continue;
            first = true;
            result.add(entry.getEvent());
            eIt.remove();
            break;
        }
        if (!first) {
            return result;
        }
        while (eIt.hasNext()) {
            entry = (Entry)eIt.next();
            if (entry.getTime().compareTo(time) != 0) continue;
            result.add(entry.getEvent());
            eIt.remove();
        }
        return result;
    }

    @Override
    public Map<E, Object> dequeueAllHashed() {
        HashMap result = new HashMap();
        if (this.isEmpty()) {
            return result;
        }
        Entry min = (Entry)((PriorityQueue)this.getData()).poll();
        result.put(min.getEvent(), null);
        while (((PriorityQueue)this.getData()).size() > 0 && min.getTime().compareTo(((Entry)((PriorityQueue)this.getData()).peek()).getTime()) == 0) {
            result.put(((Entry)((PriorityQueue)this.getData()).poll()).getEvent(), null);
        }
        return result;
    }

    @Override
    public T getMin() {
        if (this.isEmpty()) {
            return null;
        }
        return ((Entry)((PriorityQueue)this.getData()).peek()).getTime();
    }
}

