/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.core.util.eventset;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jamesii.core.util.eventset.AbstractCollectionEventQueue;
import org.jamesii.core.util.eventset.Entry;

public class LinkedListEventQueue<E, T extends Comparable<T>>
extends AbstractCollectionEventQueue<E, T, LinkedList<Entry<E, T>>> {
    private static final long serialVersionUID = 3248738589960907626L;

    public LinkedListEventQueue() {
        super(new LinkedList());
    }

    @Override
    public Entry<E, T> dequeue() {
        if (this.isEmpty()) {
            return null;
        }
        return (Entry)((LinkedList)this.getData()).remove();
    }

    @Override
    public List<E> dequeueAll() {
        ArrayList result = new ArrayList();
        if (this.isEmpty()) {
            return result;
        }
        Entry min = (Entry)((LinkedList)this.getData()).remove();
        result.add(min.getEvent());
        while (!((LinkedList)this.getData()).isEmpty() && ((Entry)((LinkedList)this.getData()).getFirst()).getTime().compareTo(min.getTime()) == 0) {
            result.add(((Entry)((LinkedList)this.getData()).remove()).getEvent());
        }
        return result;
    }

    @Override
    public List<E> dequeueAll(T time) {
        ArrayList result = new ArrayList();
        if (this.isEmpty()) {
            return result;
        }
        Iterator it = ((LinkedList)this.getData()).iterator();
        while (it.hasNext()) {
            Entry entry = (Entry)it.next();
            if (entry.getTime().compareTo(time) != 0) continue;
            do {
                result.add(entry.getEvent());
                it.remove();
            } while ((entry = it.hasNext() ? (Entry)it.next() : null) != null && entry.getTime().compareTo(time) == 0);
        }
        return result;
    }

    @Override
    public Map<E, Object> dequeueAllHashed() {
        HashMap<E, Object> result = new HashMap<E, Object>();
        if (this.isEmpty()) {
            return result;
        }
        for (E e : this.dequeueAll()) {
            result.put(e, null);
        }
        return result;
    }

    @Override
    public void enqueue(E event, T time) {
        ListIterator<Entry<E, T>> it = ((LinkedList)this.getData()).listIterator();
        while (it.hasNext()) {
            Entry entry = (Entry)it.next();
            if (entry.getTime().compareTo(time) < 0) continue;
            it.previous();
            break;
        }
        it.add(new Entry<E, T>(event, time));
    }

    @Override
    public T getMin() {
        if (((LinkedList)this.getData()).isEmpty()) {
            return null;
        }
        return ((Entry)((LinkedList)this.getData()).getFirst()).getTime();
    }
}

