/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.core.util.eventset;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jamesii.core.util.collection.Heap;
import org.jamesii.core.util.eventset.AbstractEventQueue;
import org.jamesii.core.util.eventset.Entry;

public class HeapEventQueue<E>
extends AbstractEventQueue<E, Double> {
    private static final long serialVersionUID = 8644550485545854087L;
    private Heap<Entry<E, Double>> data = new Heap();

    @Override
    public Entry<E, Double> dequeue() {
        return this.data.extractTop();
    }

    @Override
    public Double dequeue(E event) {
        Comparable t = this.getTime((Object)event);
        if (t == null) {
            return null;
        }
        this.data.remove(new Entry<E, Comparable>(event, t));
        return t;
    }

    @Override
    public List<E> dequeueAll() {
        ArrayList<E> result = new ArrayList<E>();
        Double t = null;
        Entry<E, Double> e = null;
        while ((e = this.data.extractTop()) != null) {
            if (t == null) {
                t = e.getTime();
            }
            if (e.getTime().compareTo(t) != 0) break;
            result.add(e.getEvent());
            if (e.getTime().compareTo(t) == 0) continue;
        }
        if (e != null) {
            this.data.add(e);
        }
        return result;
    }

    @Override
    public List<E> dequeueAll(Double time) {
        ArrayList<E> result = new ArrayList<E>();
        List<Entry<E, Double>> list = this.data.getList();
        for (int i = 1; i <= this.size(); ++i) {
            if (list.get(i).getTime().compareTo(time) != 0) continue;
            result.add(list.get(i).getEvent());
        }
        for (Object e : result) {
            this.data.remove(new Entry(e, time));
        }
        return result;
    }

    @Override
    public Map<E, Object> dequeueAllHashed() {
        List<E> help = this.dequeueAll();
        HashMap<E, Object> result = new HashMap<E, Object>();
        for (E e : help) {
            result.put(e, null);
        }
        return result;
    }

    @Override
    public void enqueue(E event, Double time) {
        this.data.add(new Entry<E, Double>(event, time));
    }

    @Override
    public Double getMin() {
        Entry<E, Double> e = this.data.top();
        if (e == null) {
            return null;
        }
        return e.getTime();
    }

    @Override
    public Double getTime(E event) {
        List<Entry<E, Double>> list = this.data.getList();
        for (int i = 1; i <= this.size(); ++i) {
            if (list.get(i).getEvent() != event) continue;
            return list.get(i).getTime();
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public void requeue(E event, Double time) {
        Comparable t = this.getTime((Object)event);
        if (t != null) {
            this.data.remove(new Entry<E, Comparable>(event, t));
        }
        this.enqueue(event, time);
    }

    @Override
    public void requeue(E event, Double oldTime, Double time) {
        this.data.remove(new Entry<E, Double>(event, oldTime));
        this.enqueue(event, time);
    }

    @Override
    public int size() {
        return this.data.size();
    }
}

