/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.core.util.eventset;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jamesii.core.util.eventset.BasicHashedBucketsEventQueue;
import org.jamesii.core.util.eventset.Entry;

public class BucketsThreshold<E>
extends BasicHashedBucketsEventQueue<E> {
    static final long serialVersionUID = -4699298828924476304L;
    private final Map<E, Double> events = new HashMap<E, Double>();
    private double maxTimeNearFuture = 0.0;
    private double minTimeFarFuture = Double.POSITIVE_INFINITY;
    private int threshold = 10;
    private final int numBucketsToMove = this.threshold / 2;
    private final Map<Double, Map<E, Object>> nearFuture = new HashMap<Double, Map<E, Object>>();
    private final Map<Double, Map<E, Object>> farFuture = new HashMap<Double, Map<E, Object>>();

    public BucketsThreshold() {
    }

    public BucketsThreshold(Integer thresh) {
        this.threshold = thresh;
    }

    @Override
    public Entry<E, Double> dequeue() {
        if (this.events.size() == 0) {
            return null;
        }
        Double time = this.getMin();
        Map<E, Object> l = this.nearFuture.get(time);
        E e = l.keySet().iterator().next();
        this.dequeue((Object)e);
        return new Entry<E, Double>(e, time);
    }

    @Override
    public Double dequeue(E event) {
        boolean inNearFuture;
        Double time = this.events.get(event);
        this.events.remove(event);
        Map<E, Object> list = this.nearFuture.get(time);
        boolean bl = inNearFuture = list != null;
        if (!inNearFuture) {
            list = this.farFuture.get(time);
        }
        if (list != null) {
            list.remove(event);
            if (list.size() == 0) {
                if (inNearFuture) {
                    this.nearFuture.remove(time);
                } else {
                    this.farFuture.remove(time);
                }
                if (time.compareTo(this.maxTimeNearFuture) == 0) {
                    this.maxTimeNearFuture = this.findMax(this.nearFuture);
                }
            }
        }
        return time;
    }

    @Override
    public List<E> dequeueAll() {
        return this.dequeueAll(this.getMin());
    }

    @Override
    public List<E> dequeueAll(Double time) {
        Map<E, Object> result = this.nearFuture.remove(time);
        if (result == null && (result = this.farFuture.remove(time)) == null) {
            return new ArrayList();
        }
        for (E e : result.keySet()) {
            this.events.remove(e);
        }
        return new ArrayList<E>(result.keySet());
    }

    @Override
    public Map<E, Object> dequeueAllHashed() {
        return this.dequeueAllHashed(this.getMin());
    }

    public Map<E, Object> dequeueAllHashed(Double time) {
        Map<E, Object> result = this.nearFuture.remove(time);
        if (result == null) {
            return new HashMap();
        }
        for (E e : result.keySet()) {
            this.events.remove(e);
        }
        return new HashMap<E, Object>(result);
    }

    private void addToNearFuture(E event, Double time) {
        if (this.hasBucket(time, this.nearFuture)) {
            this.putInList(this.nearFuture, time, event);
        } else if (this.nearFuture.size() < this.threshold) {
            this.putInList(this.nearFuture, time, event);
            if (Double.compare(time, this.maxTimeNearFuture) > 0) {
                this.maxTimeNearFuture = time;
            }
        } else if (Double.compare(time, this.maxTimeNearFuture) > 0) {
            this.minTimeFarFuture = time;
            this.putInList(this.farFuture, time, event);
        } else {
            this.moveBucket(this.nearFuture, this.maxTimeNearFuture, this.farFuture);
            this.minTimeFarFuture = this.maxTimeNearFuture;
            this.putInList(this.nearFuture, time, event);
            this.maxTimeNearFuture = this.findMax(this.nearFuture);
        }
    }

    @Override
    public void enqueue(E event, Double time) {
        if (time < 0.0) {
            return;
        }
        if (time != Double.POSITIVE_INFINITY) {
            if (Double.compare(time, this.minTimeFarFuture) < 0) {
                this.addToNearFuture(event, time);
            } else {
                this.putInList(this.farFuture, time, event);
            }
        }
        this.events.put(event, time);
    }

    private Double[] findMins(int mins, Map<Double, Map<E, Object>> theBuckets) {
        Double[] min = new Double[mins];
        for (int i = 0; i < mins; ++i) {
            min[i] = Double.POSITIVE_INFINITY;
        }
        block1: for (Double d : theBuckets.keySet()) {
            for (int i = 0; i < mins; ++i) {
                if (d.compareTo(min[i]) < 0) {
                    this.shift(min, i);
                    min[i] = d;
                    continue block1;
                }
                if (d.compareTo(min[i]) == 0) continue block1;
            }
        }
        return min;
    }

    @Override
    public Double getMin() {
        Double mintime = null;
        if (this.nearFuture.size() == 0) {
            Double[] min = this.findMins(this.numBucketsToMove + 1, this.farFuture);
            for (int i = 0; i < min.length - 1; ++i) {
                if (min[i] == Double.POSITIVE_INFINITY) continue;
                this.moveBucket(this.farFuture, min[i], this.nearFuture);
            }
            this.maxTimeNearFuture = min[min.length - 2];
            this.minTimeFarFuture = min[min.length - 1];
            mintime = min[0];
        } else {
            mintime = this.findMin(this.nearFuture);
        }
        if (mintime == Double.POSITIVE_INFINITY && this.events.isEmpty()) {
            return null;
        }
        this.internalGetMin(mintime);
        return mintime;
    }

    @Override
    public Double getTime(E model) {
        Double d = this.events.get(model);
        if (d != null) {
            return d;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.events.isEmpty();
    }

    private void moveBucket(Map<Double, Map<E, Object>> source, Double sourceTime, Map<Double, Map<E, Object>> target) {
        target.put(sourceTime, source.get(sourceTime));
        source.remove(sourceTime);
    }

    private void shift(Double[] arr, int breakIndex) {
        System.arraycopy(arr, breakIndex, arr, breakIndex + 1, arr.length - 1 - breakIndex);
    }

    @Override
    public int size() {
        return this.events.size();
    }

    private static String mapToString(Map<?, ?> map) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            builder.append(entry.getKey());
            builder.append("\t");
            builder.append(entry.getValue());
            builder.append("\n");
        }
        return builder.toString();
    }

    private static String mapToStringSorted(Map<Double, ?> map) {
        StringBuilder builder = new StringBuilder();
        ArrayList<Double> vals = new ArrayList<Double>();
        for (Map.Entry<Double, ?> entry : map.entrySet()) {
            vals.add(entry.getKey());
        }
        Collections.sort(vals);
        for (Double d : vals) {
            builder.append(d);
            builder.append("\t");
            builder.append(map.get(d));
            builder.append("\n");
        }
        return builder.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("min in threshold: " + this.minTimeFarFuture + "\n");
        builder.append("maxTimeNearFuture: " + this.maxTimeNearFuture + "\n");
        builder.append("nearFuture:\n " + BucketsThreshold.mapToString(this.nearFuture) + "\n");
        builder.append("farFuture:\n " + BucketsThreshold.mapToString(this.farFuture) + "\n");
        return builder.toString();
    }

    public String toString(boolean sorted) {
        if (!sorted) {
            return this.toString();
        }
        StringBuilder builder = new StringBuilder();
        builder.append("min in threshold: " + this.minTimeFarFuture + "\n");
        builder.append("maxTimeNearFuture: " + this.maxTimeNearFuture + "\n");
        builder.append("nearFuture:\n " + BucketsThreshold.mapToStringSorted(this.nearFuture) + "\n");
        builder.append("farFuture:\n " + BucketsThreshold.mapToStringSorted(this.farFuture) + "\n");
        return builder.toString();
    }
}

