/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.core.util.eventset;

import java.util.HashMap;
import java.util.Map;
import org.jamesii.core.util.eventset.AbstractEventQueue;

public abstract class BasicHashedBucketsEventQueue<E>
extends AbstractEventQueue<E, Double> {
    private static final long serialVersionUID = 3230100638771750798L;

    protected final Double findMax(Map<Double, Map<E, Object>> theList) {
        Double max = 0.0;
        for (Double d : theList.keySet()) {
            if (d.compareTo(max) <= 0) continue;
            max = d;
        }
        return max;
    }

    protected final Double findMin(Map<Double, Map<E, Object>> theList) {
        Double min = Double.POSITIVE_INFINITY;
        for (Double d : theList.keySet()) {
            if (d.compareTo(min) >= 0) continue;
            min = d;
        }
        return min;
    }

    protected final String getBucketString(Map<E, Object> theList) {
        StringBuilder result = new StringBuilder();
        for (E m : theList.keySet()) {
            if (result.length() > 0) {
                result.append(", ");
                result.append(m);
                continue;
            }
            result.append(m);
        }
        return result.toString();
    }

    protected final boolean hasBucket(double time, Map<Double, Map<E, Object>> theList) {
        return theList.containsKey(time);
    }

    public void internalGetMin(Double mintime) {
    }

    protected final void printBucket(Map<E, Object> theList) {
        System.out.println(this.getBucketString(theList));
    }

    protected final void printList(Map<Double, Map<E, Object>> theList) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Double, Map<E, Object>> d : theList.entrySet()) {
            builder.append(d);
            builder.append(": \n");
            builder.append(d);
            builder.append(": \n");
            builder.append(this.getBucketString(d.getValue()));
            builder.append("\n");
        }
    }

    protected final void putInList(Map<Double, Map<E, Object>> theList, Double time, E event) {
        Map<E, Object> list = theList.get(time);
        if (list == null) {
            list = new HashMap<E, Object>();
            theList.put(time, list);
        }
        list.put(event, null);
    }

    @Override
    public void requeue(E model, Double time) {
        this.dequeue(model);
        this.enqueue(model, time);
    }

    @Override
    public void requeue(E model, Double oldTime, Double time) {
        this.dequeue(model);
        this.enqueue(model, time);
    }
}

