/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.core.util.eventset;

import java.util.Collection;
import java.util.Iterator;
import org.jamesii.core.util.eventset.AbstractEventQueue;
import org.jamesii.core.util.eventset.Entry;

public abstract class AbstractCollectionEventQueue<E, T extends Comparable<T>, D extends Collection<Entry<E, T>>>
extends AbstractEventQueue<E, T>
implements Iterable<Entry<E, T>> {
    private static final long serialVersionUID = -1443897334400729651L;
    private final D data;

    protected AbstractCollectionEventQueue(D collection) {
        this.data = collection;
    }

    @Override
    public T dequeue(E event) {
        Iterator eIt = this.getData().iterator();
        while (eIt.hasNext()) {
            Entry entry = (Entry)eIt.next();
            if (entry.getEvent() != event) continue;
            eIt.remove();
            return entry.getTime();
        }
        return null;
    }

    @Override
    public T getTime(E event) {
        for (Entry entry : this.getData()) {
            if (entry.getEvent() != event) continue;
            return entry.getTime();
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.getData().isEmpty();
    }

    @Override
    public int size() {
        return this.getData().size();
    }

    @Override
    public void enqueue(E event, T time) {
        this.getData().add(new Entry<E, T>(event, time));
    }

    @Override
    public void requeue(E event, T newTime) {
        this.dequeue(event);
        this.enqueue(event, newTime);
    }

    @Override
    public void requeue(E event, T oldTime, T newTime) {
        this.dequeue(event);
        this.enqueue(event, newTime);
    }

    protected final D getData() {
        return this.data;
    }

    @Override
    public Iterator<Entry<E, T>> iterator() {
        return new Iterator<Entry<E, T>>(){
            private final Iterator<Entry<E, T>> it;
            {
                this.it = AbstractCollectionEventQueue.this.getData().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public Entry<E, T> next() {
                return this.it.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

