/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.core.util.collection;

import java.util.ArrayList;
import java.util.List;

public class Heap<E extends Comparable<E>> {
    private List<E> data = new ArrayList();
    private int size = 0;

    public Heap() {
        this.data.add(0, null);
    }

    public void add(E e) {
        ++this.size;
        this.data.add(this.size, e);
        if (this.size > 1) {
            this.upheap(this.size);
        }
    }

    private void downheap(int start) {
        int parent = start;
        while (parent * 2 <= this.size) {
            int actson = parent * 2;
            if (actson < this.size && ((Comparable)this.data.get(actson)).compareTo(this.data.get(actson + 1)) > 0) {
                ++actson;
            }
            if (((Comparable)this.data.get(parent)).compareTo(this.data.get(actson)) <= 0) break;
            Comparable e1 = (Comparable)this.data.get(parent);
            this.data.set(parent, this.data.get(actson));
            this.data.set(actson, e1);
            parent = actson;
        }
    }

    public E extractTop() {
        if (this.size == 0) {
            return null;
        }
        Comparable e1 = (Comparable)this.data.get(1);
        this.data.set(1, this.data.get(this.size));
        this.data.remove(this.size);
        --this.size;
        this.downheap(1);
        return (E)e1;
    }

    protected int find(E e) {
        for (int i = 1; i <= this.size; ++i) {
            if (((Comparable)this.data.get(i)).compareTo(e) != 0) continue;
            return i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void print() {
        for (Comparable d : this.data) {
            System.out.print(d + " - ");
        }
        System.out.print("\n");
    }

    public void remove() {
        if (this.size > 1) {
            this.data.set(1, this.data.get(this.size));
            this.data.remove(this.size);
            --this.size;
            this.downheap(1);
        }
    }

    public boolean remove(E e) {
        int i;
        int pos = this.find(e);
        if (pos == -1) {
            return false;
        }
        ArrayList<E> dataBackup = new ArrayList<E>(this.data);
        for (i = this.data.size() - 1; i >= pos; --i) {
            this.data.remove(i);
            --this.size;
        }
        for (i = pos + 1; i < dataBackup.size(); ++i) {
            this.add((Comparable)dataBackup.get(i));
        }
        return true;
    }

    public int size() {
        return this.size;
    }

    public E top() {
        if (this.size == 0) {
            return null;
        }
        return (E)((Comparable)this.data.get(1));
    }

    public String toString() {
        return this.data.toString();
    }

    private void upheap(int curpos) {
        while (curpos > 1 && ((Comparable)this.data.get(curpos / 2)).compareTo(this.data.get(curpos)) > 0) {
            Comparable e1 = (Comparable)this.data.get(curpos / 2);
            this.data.set(curpos / 2, this.data.get(curpos));
            this.data.set(curpos, e1);
            curpos /= 2;
        }
    }

    public List<E> getList() {
        return this.data;
    }
}

