/*
 * Decompiled with CFR 0.152.
 */
package org.jamesii.ml3.simulator.simulators.nrm;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jamesii.ml3.model.Model;
import org.jamesii.ml3.model.agents.AgentDeclaration;
import org.jamesii.ml3.simulator.simulators.nrm.DependencyManagingInstance;
import org.jamesii.ml3.simulator.simulators.nrm.ForEachInstanceSet;

public class TypeDependencyMap {
    private Map<String, Set<DependencyManagingInstance>> agentTypeDependencies = new HashMap<String, Set<DependencyManagingInstance>>();
    private Map<String, Set<ForEachInstanceSet>> agentTypeDependentInstanceSets;

    public TypeDependencyMap(Model model) {
        String agentType;
        for (AgentDeclaration ad : model.getAgentDeclarations()) {
            agentType = ad.getName();
            this.agentTypeDependencies.put(agentType, new HashSet());
        }
        this.agentTypeDependentInstanceSets = new HashMap<String, Set<ForEachInstanceSet>>();
        for (AgentDeclaration ad : model.getAgentDeclarations()) {
            agentType = ad.getName();
            this.agentTypeDependentInstanceSets.put(agentType, new HashSet());
        }
    }

    public void addTypeDependency(String type, DependencyManagingInstance instance) {
        this.agentTypeDependencies.get(type).add(instance);
    }

    public void removeTypeDependency(String type, DependencyManagingInstance instance) {
        this.agentTypeDependencies.get(type).remove(instance);
    }

    public void addTypeDependentInstanceSet(String type, ForEachInstanceSet instance) {
        this.agentTypeDependentInstanceSets.get(type).add(instance);
    }

    public void removeTypeDependentInstanceSet(String type, ForEachInstanceSet instance) {
        this.agentTypeDependentInstanceSets.get(type).remove(instance);
    }

    public Set<DependencyManagingInstance> getAgentTypeDependencies(String type) {
        return this.agentTypeDependencies.get(type);
    }

    public Set<ForEachInstanceSet> getAgentTypeDependentInstanceSets(String type) {
        return this.agentTypeDependentInstanceSets.get(type);
    }
}

